<?php 
/**
 * Everything related with social links
 *
 * @package Travel_Monster
 */

class Travel_Monster_Social_Lists{

    /**
     * Function to list all social icons
     *
     * @param [type] $social
     * @return void
     */
    public function travel_monster_lists_all_svgs( $social ){
        if( !$social ){
            return;
        }
        switch ( $social ) {
            case 'facebook':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Facebook Icon">
                    <path d="M20,10.1c0-5.5-4.5-10-10-10S0,4.5,0,10.1c0,5,3.7,9.1,8.4,9.9v-7H5.9v-2.9h2.5V7.9C8.4,5.4,9.9,4,12.2,4c1.1,0,2.2,0.2,2.2,0.2v2.5h-1.3c-1.2,0-1.6,0.8-1.6,1.6v1.9h2.8L13.9,13h-2.3v7C16.3,19.2,20,15.1,20,10.1z"/>
                </svg>';
            break;
    
            case 'twitter':
                return '<svg 
                    width="20px"
                    height="20px"
                    class="tmp-icon"
                    viewBox="0 0 20 20"
                    aria-label="Twitter Icon" 
                    fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_232_4313)">
                    <path d="M0.13108 0.139647C3.99795 5.64756 7.72555 10.9678 7.73374 10.994C7.73784 11.0114 7.58218 11.2122 7.38556 11.4392C7.18484 11.6661 6.12391 12.8925 5.01792 14.1626C2.65028 16.8903 2.3021 17.2919 0.991296 18.7976C0.446493 19.4261 0 19.9498 0 19.9629C0 19.976 0.385049 19.9891 0.856119 19.9891H1.71633L2.74859 18.8019C5.53815 15.5941 8.27035 12.4473 8.39734 12.2946L8.54071 12.1244L11.3016 16.0567L14.0584 19.9891H17.0241C18.6544 19.9891 19.9898 19.976 19.9898 19.9629C19.9898 19.9367 19.2033 18.8107 14.554 12.1855C13.0835 10.0905 11.8792 8.35787 11.8792 8.33605C11.8792 8.30986 13.4931 6.43316 15.4634 4.16802C17.4337 1.89851 19.0476 0.0349009 19.0476 0.0218076C19.0476 0.00871429 18.6544 -1.45696e-05 18.1792 0.00434986L17.3067 0.00871429L14.3574 3.40424C12.7353 5.27222 11.3303 6.89578 11.236 7.01362L11.0599 7.21875L10.9903 7.11401C10.9534 7.05727 10.0154 5.72175 8.90937 4.14619C7.80338 2.575 6.69739 0.99944 6.45161 0.641557L6.00512 -1.45696e-05H3.01895H0.0327701L0.13108 0.139647ZM8.88889 6.42443C16.3973 17.1173 17.3477 18.4746 17.3804 18.5314C17.4091 18.5837 17.2002 18.5925 16.0492 18.5925L14.6851 18.5881L13.9027 17.4664C13.0425 16.2357 9.3149 10.9242 5.23502 5.1151C3.79724 3.06818 2.62161 1.38351 2.62161 1.37042C2.62161 1.36169 3.23605 1.35732 3.98157 1.36169L5.34153 1.37478L8.88889 6.42443Z" fill="currentColor"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_232_4313">
                    <rect width="20" height="20" fill="currentColor"/>
                    </clipPath>
                    </defs>
            </svg>';
            break;
    
            case 'instagram':
                return '<svg width="20px" height="20px" viewBox="0 0 256 256" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid" aria-label="Instagram Icon">
                <g>
                    <path d="M127.999746,23.06353 C162.177385,23.06353 166.225393,23.1936027 179.722476,23.8094161 C192.20235,24.3789926 198.979853,26.4642218 203.490736,28.2166477 C209.464938,30.5386501 213.729395,33.3128586 218.208268,37.7917319 C222.687141,42.2706052 225.46135,46.5350617 227.782844,52.5092638 C229.535778,57.0201472 231.621007,63.7976504 232.190584,76.277016 C232.806397,89.7746075 232.93647,93.8226147 232.93647,128.000254 C232.93647,162.177893 232.806397,166.225901 232.190584,179.722984 C231.621007,192.202858 229.535778,198.980361 227.782844,203.491244 C225.46135,209.465446 222.687141,213.729903 218.208268,218.208776 C213.729395,222.687649 209.464938,225.461858 203.490736,227.783352 C198.979853,229.536286 192.20235,231.621516 179.722476,232.191092 C166.227425,232.806905 162.179418,232.936978 127.999746,232.936978 C93.8200742,232.936978 89.772067,232.806905 76.277016,232.191092 C63.7971424,231.621516 57.0196391,229.536286 52.5092638,227.783352 C46.5345536,225.461858 42.2700971,222.687649 37.7912238,218.208776 C33.3123505,213.729903 30.538142,209.465446 28.2166477,203.491244 C26.4637138,198.980361 24.3784845,192.202858 23.808908,179.723492 C23.1930946,166.225901 23.0630219,162.177893 23.0630219,128.000254 C23.0630219,93.8226147 23.1930946,89.7746075 23.808908,76.2775241 C24.3784845,63.7976504 26.4637138,57.0201472 28.2166477,52.5092638 C30.538142,46.5350617 33.3123505,42.2706052 37.7912238,37.7917319 C42.2700971,33.3128586 46.5345536,30.5386501 52.5092638,28.2166477 C57.0196391,26.4642218 63.7971424,24.3789926 76.2765079,23.8094161 C89.7740994,23.1936027 93.8221066,23.06353 127.999746,23.06353 M127.999746,0 C93.2367791,0 88.8783247,0.147348072 75.2257637,0.770274749 C61.601148,1.39218523 52.2968794,3.55566141 44.1546281,6.72008828 C35.7374966,9.99121548 28.5992446,14.3679613 21.4833489,21.483857 C14.3674532,28.5997527 9.99070739,35.7380046 6.71958019,44.1551362 C3.55515331,52.2973875 1.39167714,61.6016561 0.769766653,75.2262718 C0.146839975,88.8783247 0,93.2372872 0,128.000254 C0,162.763221 0.146839975,167.122183 0.769766653,180.774236 C1.39167714,194.398852 3.55515331,203.703121 6.71958019,211.845372 C9.99070739,220.261995 14.3674532,227.400755 21.4833489,234.516651 C28.5992446,241.632547 35.7374966,246.009293 44.1546281,249.28042 C52.2968794,252.444847 61.601148,254.608323 75.2257637,255.230233 C88.8783247,255.85316 93.2367791,256 127.999746,256 C162.762713,256 167.121675,255.85316 180.773728,255.230233 C194.398344,254.608323 203.702613,252.444847 211.844864,249.28042 C220.261995,246.009293 227.400247,241.632547 234.516143,234.516651 C241.632039,227.400755 246.008785,220.262503 249.279912,211.845372 C252.444339,203.703121 254.607815,194.398852 255.229725,180.774236 C255.852652,167.122183 256,162.763221 256,128.000254 C256,93.2372872 255.852652,88.8783247 255.229725,75.2262718 C254.607815,61.6016561 252.444339,52.2973875 249.279912,44.1551362 C246.008785,35.7380046 241.632039,28.5997527 234.516143,21.483857 C227.400247,14.3679613 220.261995,9.99121548 211.844864,6.72008828 C203.702613,3.55566141 194.398344,1.39218523 180.773728,0.770274749 C167.121675,0.147348072 162.762713,0 127.999746,0 Z M127.999746,62.2703115 C91.698262,62.2703115 62.2698034,91.69877 62.2698034,128.000254 C62.2698034,164.301738 91.698262,193.730197 127.999746,193.730197 C164.30123,193.730197 193.729689,164.301738 193.729689,128.000254 C193.729689,91.69877 164.30123,62.2703115 127.999746,62.2703115 Z M127.999746,170.667175 C104.435741,170.667175 85.3328252,151.564259 85.3328252,128.000254 C85.3328252,104.436249 104.435741,85.3333333 127.999746,85.3333333 C151.563751,85.3333333 170.666667,104.436249 170.666667,128.000254 C170.666667,151.564259 151.563751,170.667175 127.999746,170.667175 Z M211.686338,59.6734287 C211.686338,68.1566129 204.809755,75.0337031 196.326571,75.0337031 C187.843387,75.0337031 180.966297,68.1566129 180.966297,59.6734287 C180.966297,51.1902445 187.843387,44.3136624 196.326571,44.3136624 C204.809755,44.3136624 211.686338,51.1902445 211.686338,59.6734287 Z" fill=""></path>
                </g>
                </svg>';
            break;
    
            case 'pinterest':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Pinterest Icon">
                    <path d="M10,0C4.5,0,0,4.5,0,10c0,4.1,2.5,7.6,6,9.2c0-0.7,0-1.5,0.2-2.3c0.2-0.8,1.3-5.4,1.3-5.4s-0.3-0.6-0.3-1.6c0-1.5,0.9-2.6,1.9-2.6c0.9,0,1.3,0.7,1.3,1.5c0,0.9-0.6,2.3-0.9,3.5c-0.3,1.1,0.5,1.9,1.6,1.9c1.9,0,3.2-2.4,3.2-5.3c0-2.2-1.5-3.8-4.2-3.8c-3,0-4.9,2.3-4.9,4.8c0,0.9,0.3,1.5,0.7,2C6,12,6.1,12.1,6,12.4c0,0.2-0.2,0.6-0.2,0.8c-0.1,0.3-0.3,0.3-0.5,0.3c-1.4-0.6-2-2.1-2-3.8c0-2.8,2.4-6.2,7.1-6.2c3.8,0,6.3,2.8,6.3,5.7c0,3.9-2.2,6.9-5.4,6.9c-1.1,0-2.1-0.6-2.4-1.2c0,0-0.6,2.3-0.7,2.7c-0.2,0.8-0.6,1.5-1,2.1C8.1,19.9,9,20,10,20c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0z"/>
                </svg>';
            break;
    
            case 'telegram':
                return '<svg 
                width="20px" 
                height="20px"
                aria-label="Telegram Icon"
                viewBox="0 0 448 512" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M446.7 98.6L379.1 417.4C374 439.9 360.7 445.5 341.8 434.9L238.8 359L189.1 406.8C183.6 412.3 179 416.9 168.4 416.9L175.8 312L366.7 139.5C375 132.1 364.9 128 353.8 135.4L117.8 284L16.1998 252.2C-5.90022 245.3 -6.30022 230.1 20.7998 219.5L418.2 66.4C436.6 59.5 452.7 70.5 446.7 98.6V98.6Z"/>
                </svg>';
            break;
    
            case 'linkedin':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="LinkedIn Icon">
                    <path d="M18.6,0H1.4C0.6,0,0,0.6,0,1.4v17.1C0,19.4,0.6,20,1.4,20h17.1c0.8,0,1.4-0.6,1.4-1.4V1.4C20,0.6,19.4,0,18.6,0z M6,17.1h-3V7.6h3L6,17.1L6,17.1zM4.6,6.3c-1,0-1.7-0.8-1.7-1.7s0.8-1.7,1.7-1.7c0.9,0,1.7,0.8,1.7,1.7C6.3,5.5,5.5,6.3,4.6,6.3z M17.2,17.1h-3v-4.6c0-1.1,0-2.5-1.5-2.5c-1.5,0-1.8,1.2-1.8,2.5v4.7h-3V7.6h2.8v1.3h0c0.4-0.8,1.4-1.5,2.8-1.5c3,0,3.6,2,3.6,4.5V17.1z"/>
                </svg>';
            break;
    
            case 'tiktok':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="TikTok Icon">
                    <path d="M18.2 4.5c-2.3-.2-4.1-1.9-4.4-4.2V0h-3.4v13.8c0 1.4-1.2 2.6-2.8 2.6-1.4 0-2.6-1.1-2.6-2.6s1.1-2.6 2.6-2.6h.2l.5.1V7.5h-.7c-3.4 0-6.2 2.8-6.2 6.2S4.2 20 7.7 20s6.2-2.8 6.2-6.2v-7c1.1 1.1 2.4 1.6 3.9 1.6h.8V4.6l-.4-.1z"/>
                </svg>';
            break;
    
    
            case 'skype':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="Skype Icon">
                    <path d="M5.7 0C2.6 0 0 2.5 0 5.6c0 1 .2 1.9.7 2.7-.1.6-.2 1.2-.2 1.8 0 5.2 4.3 9.4 9.6 9.4.5 0 1.1 0 1.6-.1.8.4 1.7.6 2.6.6 3.1 0 5.7-2.5 5.7-5.6 0-.8-.2-1.6-.5-2.4.1-.6.2-1.2.2-1.9 0-5.2-4.3-9.4-9.6-9.4-.5 0-1 0-1.5.1C7.7.3 6.7 0 5.7 0zM10 3.8c.8 0 1.5.1 2.1.3.6.2 1.1.4 1.5.7.4.3.7.6.9 1 .2.3.3.7.3 1 0 .3-.1.6-.4.9s-.5.3-.8.3c-.3 0-.6-.1-.8-.2-.2-.2-.4-.4-.6-.7-.2-.4-.5-.8-.8-1-.3-.2-.8-.3-1.5-.3s-1.2.1-1.6.4c-.4.2-.6.5-.6.8 0 .2.1.4.2.5.1.2.3.3.5.4.3.1.5.2.8.3.3.1.7.2 1.3.3.7.2 1.4.3 2 .5.6.2 1.1.4 1.6.7.4.3.8.6 1 1.1s.4 1 .4 1.6c0 .7-.2 1.4-.6 2-.4.6-1.1 1.1-1.9 1.4-.8.3-1.8.5-2.9.5-1.3 0-2.4-.2-3.3-.7-.6-.3-1.1-.8-1.5-1.3-.4-.6-.6-1.1-.6-1.6 0-.3.1-.6.4-.9.3-.2.6-.3.9-.3.3 0 .6.1.8.3.2.2.4.4.5.8.2.4.3.7.5.9.2.2.4.4.8.6.3.2.8.2 1.3.2.8 0 1.4-.2 1.8-.5.5-.3.7-.7.7-1.1 0-.4-.1-.6-.4-.9-.2-.2-.6-.4-1-.5-.4-.1-1-.3-1.7-.4-.9-.2-1.8-.4-2.4-.7-.4-.3-1-.7-1.3-1.2-.4-.5-.7-1.1-.7-1.8s.2-1.3.6-1.8c.4-.5 1-.9 1.8-1.2.8-.3 1.7-.4 2.7-.4z"/>
                </svg>';
            break;
    
    
            case 'youtube':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewbox="0 0 20 20"
                aria-label="YouTube Icon">
                    <path d="M15,0H5C2.2,0,0,2.2,0,5v10c0,2.8,2.2,5,5,5h10c2.8,0,5-2.2,5-5V5C20,2.2,17.8,0,15,0z M14.5,10.9l-6.8,3.8c-0.1,0.1-0.3,0.1-0.5,0.1c-0.5,0-1-0.4-1-1l0,0V6.2c0-0.5,0.4-1,1-1c0.2,0,0.3,0,0.5,0.1l6.8,3.8c0.5,0.3,0.7,0.8,0.4,1.3C14.8,10.6,14.6,10.8,14.5,10.9z"/>
                </svg>';
            break;
    
            case 'vimeo':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="Vimeo Icon">
                    <path d="M20,5.3c-0.1,1.9-1.4,4.6-4.1,8c-2.7,3.5-5,5.3-6.9,5.3c-1.2,0-2.2-1.1-3-3.2C4.5,9.7,3.8,6.3,2.5,6.3c-0.2,0-0.7,0.3-1.6,0.9L0,6c2.3-2,4.5-4.3,5.9-4.4c1.6-0.2,2.5,0.9,2.9,3.2c1.3,8.1,1.8,9.3,4.2,5.7c0.8-1.3,1.3-2.3,1.3-3c0.2-2-1.6-1.9-2.8-1.4c1-3.2,2.9-4.8,5.6-4.7C19.1,1.4,20.1,2.7,20,5.3L20,5.3z"/>
                </svg>';
            break;
    
            case 'vk':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="VKontakte Icon">
                    <path d="M19.2,4.8H16c-0.3,0-0.5,0.1-0.6,0.4c0,0-1.3,2.4-1.7,3.2c-1.1,2.2-1.8,1.5-1.8,0.5V5.4c0-0.6-0.5-1.1-1.1-1.1H8.2C7.6,4.3,6.9,4.6,6.5,5.1c0,0,1.2-0.2,1.2,1.5c0,0.4,0,1.6,0,2.6c0,0.4-0.3,0.7-0.7,0.7c-0.2,0-0.4-0.1-0.6-0.2c-1-1.4-1.8-2.9-2.5-4.5C4,5,3.7,4.8,3.5,4.8c-0.7,0-2.1,0-2.9,0C0.2,4.8,0,5,0,5.3c0,0.1,0,0.1,0,0.2C0.9,8,4.8,15.7,9.2,15.7H11c0.4,0,0.7-0.3,0.7-0.7v-1.1c0-0.4,0.3-0.7,0.7-0.7c0.2,0,0.4,0.1,0.5,0.2l2.2,2.1c0.2,0.2,0.5,0.3,0.7,0.3h2.9c1.4,0,1.4-1,0.6-1.7c-0.5-0.5-2.5-2.6-2.5-2.6c-0.3-0.4-0.4-0.9-0.1-1.3c0.6-0.8,1.7-2.2,2.1-2.8C19.6,6.5,20.7,4.8,19.2,4.8z"/>
                </svg>';
            break;
    
            case 'ok':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Odnoklassniki Icon">
                    <path d="M8.2,6.5c0-1,0.8-1.8,1.8-1.8s1.8,0.8,1.8,1.8c0,1-0.8,1.8-1.8,1.8S8.2,7.5,8.2,6.5L8.2,6.5z M20,2.1v15.7c0,1.2-1,2.1-2.1,2.1H2.1C1,20,0,19,0,17.9V2.1C0,1,1,0,2.1,0h15.7C19,0,20,1,20,2.1z M6.4,6.5c0,2,1.6,3.6,3.6,3.6s3.6-1.6,3.6-3.6c0-2-1.6-3.6-3.6-3.6S6.4,4.5,6.4,6.5z M14.2,10.5c-0.2-0.4-0.8-0.8-1.5-0.2c0,0-1,0.8-2.6,0.8s-2.6-0.8-2.6-0.8C6.6,9.8,6,10.1,5.8,10.5c-0.4,0.7,0,1.1,1,1.7c0.8,0.5,1.8,0.7,2.5,0.8l-0.6,0.6c-0.8,0.8-1.6,1.6-2.1,2.1c-0.8,0.8,0.5,2,1.3,1.3l2.1-2.1c0.8,0.8,1.6,1.6,2.1,2.1c0.8,0.8,2.1-0.5,1.3-1.3l-2.1-2.1l-0.6-0.6c0.7-0.1,1.7-0.3,2.5-0.8C14.1,11.6,14.5,11.2,14.2,10.5z"/>
                </svg>';
            break;
    
            case 'rss':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="RSS Icon">
                    <path d="M17.9,0H2.1C1,0,0,1,0,2.1v15.7C0,19,1,20,2.1,20h15.7c1.2,0,2.1-1,2.1-2.1V2.1C20,1,19,0,17.9,0z M5,17.1c-1.2,0-2.1-1-2.1-2.1s1-2.1,2.1-2.1s2.1,1,2.1,2.1S6.2,17.1,5,17.1z M12,17.1h-1.5c-0.3,0-0.5-0.2-0.5-0.5c-0.2-3.6-3.1-6.4-6.7-6.7c-0.3,0-0.5-0.2-0.5-0.5V8c0-0.3,0.2-0.5,0.5-0.5c4.9,0.3,8.9,4.2,9.2,9.2C12.6,16.9,12.3,17.1,12,17.1L12,17.1z M16.6,17.1h-1.5c-0.3,0-0.5-0.2-0.5-0.5c-0.2-6.1-5.1-11-11.2-11.2c-0.3,0-0.5-0.2-0.5-0.5V3.4c0-0.3,0.2-0.5,0.5-0.5c7.5,0.3,13.5,6.3,13.8,13.8C17.2,16.9,16.9,17.1,16.6,17.1L16.6,17.1z"/>
                </svg>';
            break;
    
            case 'facebook_group':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Facebook Group Icon">
                    <path d="M3.3,18.4c-0.2-0.5,0.3-2.8,0.7-3.7c0.5-1.1,1.6-2,2.5-2.3c0.6-0.2,0.7-0.2,2.1,0.5l1.4,0.7l1.4-0.7c0.8-0.4,1.5-0.7,1.8-0.7c0.5,0,1.8,0.9,2.4,1.6c0.6,0.9,1.1,2.3,1.2,3.7l0,1.1l-6.7,0C4,18.7,3.4,18.6,3.3,18.4z M0.1,12.8c-0.4-0.9,0.6-3.4,1.6-4.1c0.8-0.5,1.5-0.5,2.5,0.1c0.6,0.4,0.9,0.5,1.1,0.3C5.6,9,5.7,9,5.9,9.3c0.2,0.2,0.6,0.6,0.9,1c0.6,0.6,0.6,0.7-0.4,1.1c-0.4,0.1-1.1,0.5-1.6,1l-0.9,0.7H2.1C0.5,13.1,0.2,13,0.1,12.8z M15.3,12.4c-0.4-0.4-1.1-0.8-1.5-1c-1.1-0.4-1.1-0.5-0.5-1.1c0.3-0.3,0.7-0.7,0.9-1C14.4,9,14.5,9,14.8,9.1c0.2,0.1,0.5,0,1.1-0.3c0.5-0.3,1.1-0.5,1.4-0.5c1.3,0,2.6,1.8,2.7,3.7l0,1l-2,0l-2,0L15.3,12.4z M8.4,10.6C7,9.9,6,8.4,6,6.9c0-2.1,2-4.1,4.1-4.1s4.1,2,4.1,4.1S12.1,11,10,11C9.6,11,8.9,10.8,8.4,10.6z M3.5,6.8c-1.7-1-1.9-3.5-0.4-4.7c1.1-0.9,2.5-1,3.6-0.2c1,0.7,1,0.9,0.2,1.6c-0.8,0.7-1.4,1.8-1.5,3C5.2,7.2,5.2,7.3,4.7,7.3C4.4,7.3,3.9,7.1,3.5,6.8z M14.8,6.5c-0.2-1.2-0.7-2.3-1.5-3c-0.8-0.7-0.8-0.9,0.2-1.6C15.4,0.6,18,2,18,4.3c0,1.5-1.4,3-2.7,3C14.9,7.3,14.9,7.2,14.8,6.5z"/>
                </svg>';
            break;
    
            case 'tripadvisor':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="TripAdvisor Icon">
                    <path d="M5.9 10.7c0 .4-.4.8-.8.8s-.8-.4-.8-.8.4-.8.8-.8.8.3.8.8zm1.7 0c0 1.3-1.1 2.4-2.4 2.4S2.7 12 2.7 10.7c0-1.3 1.1-2.4 2.4-2.4s2.5 1 2.5 2.4zm-.9 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm8.2-.8c-.4 0-.8.4-.8.8s.4.8.8.8.8-.4.8-.8c0-.5-.4-.8-.8-.8zm2.4.8c0 1.3-1.1 2.4-2.4 2.4s-2.4-1.1-2.4-2.4c0-1.3 1.1-2.4 2.4-2.4s2.4 1 2.4 2.4zm-.8 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm1.6 4.1c-2.1 1.7-5.2 1.3-6.9-.8l-.9 1.5c0 .1-.1.1-.1.1-.2.1-.4.1-.6-.1L8.7 14c-1.7 2.1-4.7 2.5-6.9.8-2-1.7-2.4-4.8-.8-6.9-.1-.5-.4-1-.7-1.4 0-.1-.1-.2-.1-.3 0-.2.2-.4.4-.4h3.1c3.9-2.2 8.7-2.2 12.6 0h3.1c.1 0 .2 0 .3.1.2.1.2.4 0 .6-.3.4-.6.9-.8 1.4 1.7 2.1 1.3 5.2-.8 6.9zm-8.9-4.1c0-2.2-1.8-4.1-4.1-4.1h-1C2.3 7.1 1 8.8 1 10.7c0 2.2 1.9 4 4.1 4 2.3.1 4.1-1.8 4.1-4zm6.6-4h-.2c-.2 0-.5-.1-.7-.1-2.2 0-4 1.7-4.1 3.9 0 .7.2 1.4.5 2.1.1.1.1.2.2.3.8 1.1 2 1.8 3.4 1.8 1.9 0 3.5-1.3 3.9-3.1.5-2.1-.8-4.3-3-4.9z"/>
                </svg>';
            break;
    
            case 'xing':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="Xing Icon">
                    <path d="M16.8,0H3.2C1.4,0,0,1.4,0,3.2v13.6C0,18.6,1.4,20,3.2,20h13.6c1.8,0,3.2-1.4,3.2-3.2V3.2C20,1.4,18.6,0,16.8,0z M6.2,13.3H3.8c-0.2,0-0.3-0.3-0.3-0.4L6,8.4c0.1-0.1,0.1-0.2,0-0.3L4.5,5.4C4.4,5.3,4.5,5,4.7,5H7c0.1,0,0.2,0.1,0.3,0.2L9,8.2c0.1,0.1,0.1,0.2,0,0.3l-2.6,4.7C6.4,13.2,6.2,13.3,6.2,13.3z M16.3,2.9l-4.7,8.6c-0.1,0.1-0.1,0.2,0,0.3l3,5.3c0.1,0.2,0,0.4-0.3,0.4h-2.3c-0.1,0-0.2-0.1-0.3-0.2l-3.2-5.6c-0.1-0.1-0.1-0.2,0-0.3l4.8-8.9c0.1,0,0.3-0.1,0.3-0.1h2.3C16.3,2.5,16.4,2.8,16.3,2.9z"/>
                </svg>';
            break;
    
            case 'whatsapp':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="WhatsApp Icon">
                    <path d="M10,0C4.5,0,0,4.5,0,10c0,1.9,0.5,3.6,1.4,5.1L0.1,20l5-1.3C6.5,19.5,8.2,20,10,20c5.5,0,10-4.5,10-10S15.5,0,10,0zM6.6,5.3c0.2,0,0.3,0,0.5,0c0.2,0,0.4,0,0.6,0.4c0.2,0.5,0.7,1.7,0.8,1.8c0.1,0.1,0.1,0.3,0,0.4C8.3,8.2,8.3,8.3,8.1,8.5C8,8.6,7.9,8.8,7.8,8.9C7.7,9,7.5,9.1,7.7,9.4c0.1,0.2,0.6,1.1,1.4,1.7c0.9,0.8,1.7,1.1,2,1.2c0.2,0.1,0.4,0.1,0.5-0.1c0.1-0.2,0.6-0.7,0.8-1c0.2-0.2,0.3-0.2,0.6-0.1c0.2,0.1,1.4,0.7,1.7,0.8s0.4,0.2,0.5,0.3c0.1,0.1,0.1,0.6-0.1,1.2c-0.2,0.6-1.2,1.1-1.7,1.2c-0.5,0-0.9,0.2-3-0.6c-2.5-1-4.1-3.6-4.2-3.7c-0.1-0.2-1-1.3-1-2.6c0-1.2,0.6-1.8,0.9-2.1C6.1,5.4,6.4,5.3,6.6,5.3z"/>
                </svg>';
            break;
    
            case 'viber':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Viber Icon">
                    <path d="M18.6,4.4c-0.3-1.2-1-2.2-2-2.9c-1.2-0.9-2.7-1.2-3.9-1.4C11,0,9.4-0.1,8,0.1C6.6,0.3,5.5,0.6,4.6,1c-1.9,0.9-3,2.2-3.3,4.1C1.1,6,1,6.9,0.9,7.6c-0.2,1.8,0,3.4,0.4,4.9c0.4,1.5,1.2,2.5,2.2,3.2c0.3,0.2,0.6,0.3,1,0.4c0.2,0.1,0.3,0.1,0.5,0.2v2.9C5,19.7,5.3,20,5.7,20l0,0c0.2,0,0.4-0.1,0.5-0.2l2.7-2.6C9,17,9,17,9.1,17c0.9,0,1.9-0.1,2.8-0.1c1.1-0.1,2.5-0.2,3.7-0.7c1.1-0.5,2-1.2,2.5-2.2c0.5-1.1,0.8-2.2,0.9-3.5C19.3,8.2,19.1,6.2,18.6,4.4z M13.9,13.1c-0.3,0.4-0.7,0.8-1.2,1c-0.4,0.1-0.7,0.1-1.1,0C8.8,12.8,6.5,10.9,5,8.1C4.7,7.5,4.5,6.9,4.2,6.3C4.2,6.2,4.2,6,4.2,5.9c0-1,0.8-1.5,1.5-1.7c0.3-0.1,0.5,0,0.8,0.2c0.6,0.6,1.1,1.2,1.4,2C8,6.7,8,7,7.7,7.2C7.6,7.3,7.6,7.3,7.5,7.4C6.9,7.8,6.8,8.2,7.2,8.9c0.5,1.2,1.5,1.9,2.6,2.4c0.3,0.1,0.6,0.1,0.8-0.2c0,0,0.1-0.1,0.1-0.1c0.5-0.8,1.1-0.7,1.8-0.3c0.4,0.3,0.8,0.6,1.2,0.9C14.3,12.1,14.3,12.5,13.9,13.1z M10.4,5.1c-0.2,0-0.3,0-0.5,0C9.7,5.2,9.5,5,9.4,4.8c0-0.3,0.1-0.5,0.4-0.5c0.2,0,0.4-0.1,0.6-0.1c2.1,0,3.7,1.7,3.7,3.7c0,0.2,0,0.4-0.1,0.6c0,0.2-0.2,0.4-0.5,0.4c0,0-0.1,0-0.1,0c-0.3,0-0.4-0.3-0.4-0.5c0-0.2,0-0.3,0-0.5C13.2,6.4,12,5.1,10.4,5.1z M12.5,8.2c0,0.3-0.2,0.5-0.5,0.5s-0.5-0.2-0.5-0.5c0-0.8-0.6-1.4-1.4-1.4c-0.3,0-0.5-0.2-0.5-0.5c0-0.3,0.2-0.5,0.5-0.5C11.4,5.8,12.5,6.9,12.5,8.2zM15.7,8.8c-0.1,0.2-0.2,0.4-0.5,0.4c0,0-0.1,0-0.1,0c-0.3-0.1-0.4-0.3-0.4-0.6c0.1-0.3,0.1-0.6,0.1-0.9c0-2.3-1.9-4.2-4.2-4.2c-0.3,0-0.6,0-0.9,0.1C9.5,3.6,9.2,3.5,9.2,3.2C9.1,2.9,9.3,2.7,9.5,2.6c0.4-0.1,0.8-0.1,1.1-0.1c2.8,0,5.2,2.3,5.2,5.2C15.8,8,15.8,8.4,15.7,8.8z"/>
                </svg>';
            break;
    
            case 'line':
                return '<svg
                class="tmp-icon"
                width="20px"
                height="20px"
                viewBox="0 0 20 20"
                aria-label="Line Icon">
                    <path d="M16.1 8.2c.3 0 .5.2.5.5s-.2.5-.5.5h-1.5v.9h1.5c.3 0 .5.2.5.5s-.2.5-.5.5h-2c-.3 0-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5h2c.3 0 .5.2.5.5s-.2.5-.5.5h-1.5V8h1.5zm-3.2 2.5c0 .2-.1.4-.4.5h-.2c-.2 0-.3-.1-.4-.2l-2-2.8v2.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-4c0-.2.1-.4.4-.5h.2c.2 0 .3.1.4.2L12 9.2V6.8c0-.3.2-.5.5-.5s.5.2.5.5v3.9zm-4.8 0c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5s.5.2.5.5v4zm-2 .6h-2c-.3 0-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5s.5.2.5.5v3.5h1.5c.3 0 .5.2.5.5 0 .2-.2.5-.5.5M20 8.6C20 4.1 15.5.5 10 .5S0 4.1 0 8.6c0 4 3.6 7.4 8.4 8 .3.1.8.2.9.5.1.3.1.6 0 .9l-.1.9c0 .3-.2 1 .9.5 1.1-.4 5.8-3.4 7.9-5.8 1.3-1.6 2-3.2 2-5"/>
                </svg>';
            break;
    
            case 'weibo':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="Weibo Icon">
                    <path d="M15.9,7.6c0.3-0.9-0.5-1.8-1.5-1.6c-0.9,0.2-1.1-1.1-0.3-1.3c2-0.4,3.6,1.4,3,3.3C16.9,8.8,15.6,8.4,15.9,7.6z M8.4,18.1c-4.2,0-8.4-2-8.4-5.3C0,11,1.1,9,3,7.2c3.9-3.9,7.9-3.9,6.8-0.2c-0.2,0.5,0.5,0.2,0.5,0.2c3.1-1.3,5.5-0.7,4.5,2c-0.1,0.4,0,0.4,0.3,0.5C20.3,11.3,16.4,18.1,8.4,18.1L8.4,18.1zM14,12.4c-0.2-2.2-3.1-3.7-6.4-3.3C4.3,9.4,1.8,11.4,2,13.6s3.1,3.7,6.4,3.3C11.7,16.6,14.2,14.6,14,12.4zM13.6,2c-1,0.2-0.7,1.7,0.3,1.5c2.8-0.6,5.3,2.1,4.4,4.8c-0.3,0.9,1.1,1.4,1.5,0.5C21,4.9,17.6,1.2,13.6,2L13.6,2z M10.5,14.2c-0.7,1.5-2.6,2.3-4.3,1.8c-1.6-0.5-2.3-2.1-1.6-3.5c0.7-1.4,2.5-2.2,4-1.8C10.4,11.1,11.2,12.7,10.5,14.2zM7.2,13c-0.5-0.2-1.2,0-1.5,0.5C5.3,14,5.5,14.6,6,14.8c0.5,0.2,1.2,0,1.5-0.5C7.8,13.8,7.7,13.2,7.2,13zM8.4,12.5c-0.2-0.1-0.4,0-0.6,0.2c-0.1,0.2-0.1,0.4,0.1,0.5c0.2,0.1,0.5,0,0.6-0.2C8.7,12.8,8.6,12.6,8.4,12.5z"/>
                </svg>';
            break;
    
            case 'tumblr':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="Tumblr Icon">
                    <path d="M18,0H2C0.9,0,0,0.9,0,2v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V2C20,0.9,19.1,0,18,0z M15,15.9c0,0,0,0.1-0.1,0.1c0,0-1.4,1-3.9,1c-3,0-3-3.6-3-4V9H6.2C6.1,9,6,8.9,6,8.8V7.2C6,7.1,6,7,6.1,7C6.1,7,9,5.7,9,3.2C9,3.1,9.1,3,9.2,3h1.7C10.9,3,11,3.1,11,3.2V7h2.8C13.9,7,14,7.1,14,7.2v1.7C14,8.9,13.9,9,13.8,9H11v4c0,0.1-0.1,1.3,1.2,1.3c1.1,0,2.5-0.3,2.5-0.3c0.1,0,0.1,0,0.2,0c0.1,0,0.1,0.1,0.1,0.2V15.9z"/>
                </svg>';
            break;
    
            case 'qq':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="QQ Icon">
                    <path d="M18.2,16.4c-0.5,0.1-1.8-2.1-1.8-2.1c0,1.2-0.6,2.8-2,4c0.7,0.2,2.1,0.7,1.8,1.3C16,20.2,11.3,20,10,19.8c-1.3,0.2-5.9,0.3-6.2-0.2c-0.4-0.6,1.1-1.1,1.8-1.3c-1.4-1.2-2-2.8-2-4c0,0-1.3,2.1-1.8,2.1c-0.2,0-0.5-1.2,0.4-3.9c0.4-1.3,0.9-2.4,1.6-4.1C3.6,3.8,5.5,0,10,0c4.4,0,6.4,3.8,6.3,8.4c0.7,1.8,1.2,2.8,1.6,4.1C18.7,15.3,18.4,16.4,18.2,16.4L18.2,16.4z"/>
                </svg>';
            break;
    
            case 'wechat':
                return '<svg
                class="tmp-icon"
                width="20"
                height="20"
                viewBox="0 0 20 20"
                aria-label="WeChat Icon">
                    <path d="M13.5,6.8c0.2,0,0.5,0,0.7,0c-0.6-2.9-3.7-5-7.1-5C3.2,1.9,0,4.5,0,7.9c0,1.9,1.1,3.5,2.8,4.8l-0.7,2.1l2.5-1.2c0.9,0.2,1.6,0.4,2.5,0.4c0.2,0,0.4,0,0.7,0c-0.1-0.5-0.2-1-0.2-1.5C7.5,9.3,10.2,6.8,13.5,6.8L13.5,6.8zM9.7,4.9c0.5,0,0.9,0.4,0.9,0.9c0,0.5-0.4,0.9-0.9,0.9c-0.5,0-1.1-0.4-1.1-0.9C8.7,5.2,9.2,4.9,9.7,4.9zM4.8,6.6c-0.5,0-1.1-0.4-1.1-0.9c0-0.5,0.5-0.9,1.1-0.9c0.5,0,0.9,0.4,0.9,0.9C5.7,6.3,5.3,6.6,4.8,6.6z M20,12.3c0-2.8-2.8-5.1-6-5.1c-3.4,0-6,2.3-6,5.1s2.6,5.1,6,5.1c0.7,0,1.4-0.2,2.1-0.4l1.9,1.1l-0.5-1.8C18.9,15.3,20,13.9,20,12.3zM12,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C12.9,11.1,12.6,11.4,12,11.4zM15.9,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C16.8,11.1,16.5,11.4,15.9,11.4z"/>
                </svg>';
            break;

            case 'reddit':
                return '<svg width="20px" height="20px" viewBox="0 0 20 20"><path fill="currentcolor" d="M11.7,0.9c-0.9,0-2,0.7-2.1,3.9c0.1,0,0.3,0,0.4,0c0.2,0,0.3,0,0.5,0c0.1-1.9,0.6-3.1,1.3-3.1c0.3,0,0.5,0.2,0.8,0.5c0.4,0.4,0.9,0.9,1.8,1.1c0-0.1,0-0.2,0-0.4c0-0.2,0-0.4,0.1-0.5c-0.6-0.2-0.9-0.5-1.2-0.8C12.8,1.3,12.4,0.9,11.7,0.9z M16.9,1.3c-1,0-1.7,0.8-1.7,1.7s0.8,1.7,1.7,1.7s1.7-0.8,1.7-1.7S17.9,1.3,16.9,1.3z M10,5.7c-5.3,0-9.5,2.7-9.5,6.5s4.3,6.9,9.5,6.9s9.5-3.1,9.5-6.9S15.3,5.7,10,5.7z M2.4,6.1c-0.6,0-1.2,0.3-1.7,0.7C0,7.5-0.2,8.6,0.2,9.5C0.9,8.2,2,7.1,3.5,6.3C3.1,6.2,2.8,6.1,2.4,6.1z M17.6,6.1c-0.4,0-0.7,0.1-1.1,0.3c1.5,0.8,2.6,1.9,3.2,3.2c0.4-0.9,0.3-2-0.5-2.7C18.8,6.3,18.2,6.1,17.6,6.1z M6.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S5.8,9.6,6.5,9.6z M13.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S12.8,9.6,13.5,9.6z M6.1,14.3c0.1,0,0.2,0.1,0.3,0.2c0,0.1,1.1,1.4,3.6,1.4c2.6,0,3.6-1.4,3.6-1.4c0.1-0.2,0.4-0.2,0.6-0.1c0.2,0.1,0.2,0.4,0.1,0.6c-0.1,0.1-1.3,1.8-4.3,1.8c-3,0-4.2-1.7-4.3-1.8c-0.1-0.2-0.1-0.5,0.1-0.6C5.9,14.4,6,14.3,6.1,14.3z"/></svg>';
            break;

            case 'digg':
                return '<svg width="20px" height="20px" viewBox="0 0 512 512" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill="currentcolor" d="M81.7 172.3H0V346.7H132.7V96H81.7V172.3V172.3ZM81.7 305.7H50.9V213.4H81.7V305.7ZM378.9 172.3V346.7H460.7V375.2H378.9V416H512V172.3H378.9V172.3ZM460.7 305.7H429.9V213.4H460.7V305.7ZM225.1 346.7H307.2V375.2H225.1V416H358.4V172.3H225.1V346.7ZM276.3 213.4H307.1V305.7H276.3V213.4ZM153.3 96H204.6V147H153.3V96ZM153.3 172.3H204.6V346.7H153.3V172.3Z"/></svg>';
            break;
            
            case 'getpocket':
                return '<svg width="20px" height="20px" viewBox="0 0 448 512" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill="currentcolor" d="M407.6 64H40.6C18.5 64 0 82.5 0 104.6V239.8C0 364.5 99.7 464 224.2 464C348.2 464 448 364.5 448 239.8V104.6C448 82.2 430.3 64 407.6 64V64ZM245.6 332.5C233.2 344.3 214.2 343.6 203.2 332.5C89.5 223.6 88.3 227.4 88.3 209.3C88.3 192.4 102.1 178.6 119 178.6C136 178.6 135.1 182.4 224.2 267.9C314.8 181 312.8 178.6 329.7 178.6C346.6 178.6 360.4 192.4 360.4 209.3C360.4 227.1 357.5 225 245.6 332.5V332.5Z"/></svg>';
            break;

            case 'snapchat':
                return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path fill="currentcolor" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm169.5 338.9c-3.5 8.1-18.1 14-44.8 18.2-1.4 1.9-2.5 9.8-4.3 15.9-1.1 3.7-3.7 5.9-8.1 5.9h-.2c-6.2 0-12.8-2.9-25.8-2.9-17.6 0-23.7 4-37.4 13.7-14.5 10.3-28.4 19.1-49.2 18.2-21 1.6-38.6-11.2-48.5-18.2-13.8-9.7-19.8-13.7-37.4-13.7-12.5 0-20.4 3.1-25.8 3.1-5.4 0-7.5-3.3-8.3-6-1.8-6.1-2.9-14.1-4.3-16-13.8-2.1-44.8-7.5-45.5-21.4-.2-3.6 2.3-6.8 5.9-7.4 46.3-7.6 67.1-55.1 68-57.1 0-.1.1-.2.2-.3 2.5-5 3-9.2 1.6-12.5-3.4-7.9-17.9-10.7-24-13.2-15.8-6.2-18-13.4-17-18.3 1.6-8.5 14.4-13.8 21.9-10.3 5.9 2.8 11.2 4.2 15.7 4.2 3.3 0 5.5-.8 6.6-1.4-1.4-23.9-4.7-58 3.8-77.1C183.1 100 230.7 96 244.7 96c.6 0 6.1-.1 6.7-.1 34.7 0 68 17.8 84.3 54.3 8.5 19.1 5.2 53.1 3.8 77.1 1.1.6 2.9 1.3 5.7 1.4 4.3-.2 9.2-1.6 14.7-4.2 4-1.9 9.6-1.6 13.6 0 6.3 2.3 10.3 6.8 10.4 11.9.1 6.5-5.7 12.1-17.2 16.6-1.4.6-3.1 1.1-4.9 1.7-6.5 2.1-16.4 5.2-19 11.5-1.4 3.3-.8 7.5 1.6 12.5.1.1.1.2.2.3.9 2 21.7 49.5 68 57.1 4 1 7.1 5.5 4.9 10.8z"/></svg>';
            break;

            case 'phone':
                return '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19.6324 15.6665L15.0688 11.5171C14.8531 11.321 14.5696 11.2165 14.2782 11.2255C13.9868 11.2345 13.7104 11.3564 13.5071 11.5654L10.8206 14.3283C10.1739 14.2048 8.87389 13.7995 7.53567 12.4646C6.19745 11.1253 5.79217 9.82189 5.67204 9.17972L8.43268 6.49205C8.64196 6.28899 8.76402 6.01247 8.77303 5.72101C8.78204 5.42955 8.6773 5.14601 8.48096 4.93042L4.3327 0.36789C4.13628 0.151615 3.86328 0.0204285 3.5717 0.00219121C3.28011 -0.016046 2.9929 0.0801029 2.77106 0.270218L0.334872 2.3595C0.140775 2.5543 0.024925 2.81357 0.0092979 3.08812C-0.00754213 3.36878 -0.328625 10.0172 4.82667 15.1748C9.32408 19.6711 14.9576 20 16.5092 20C16.7359 20 16.8752 19.9933 16.9122 19.991C17.1867 19.9757 17.4458 19.8593 17.6397 19.6643L19.7279 17.227C19.9187 17.0059 20.0156 16.7189 19.9978 16.4273C19.9799 16.1358 19.8488 15.8627 19.6324 15.6665Z" fill="#F7F7F7"/>
                        </svg>';
            break;
    
            case 'clock':
                return '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10 0C4.486 0 0 4.486 0 10C0 15.514 4.486 20 10 20C15.514 20 20 15.514 20 10C20 4.486 15.514 0 10 0ZM13.293 14.707L9 10.414V4H11V9.586L14.707 13.293L13.293 14.707Z" fill="#F7F7F7"></path>
                        </svg>';
            break;
    
            case 'email':
                return '<svg width="20" height="20" viewBox="0 0 20 20"><path d="M10,10.1L0,4.7C0.1,3.2,1.4,2,3,2h14c1.6,0,2.9,1.2,3,2.8L10,10.1z M10,11.8c-0.1,0-0.2,0-0.4-0.1L0,6.4V15c0,1.7,1.3,3,3,3h4.9h4.3H17c1.7,0,3-1.3,3-3V6.4l-9.6,5.2C10.2,11.7,10.1,11.7,10,11.8z"/></svg>';
            break;
    
            case 'location':
                return '<svg width="16" height="20" viewBox="0 0 16 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.85715 0C5.77406 0.00245748 3.77699 0.831051 2.30403 2.30402C0.831059 3.77699 0.00246584 5.77405 8.3592e-06 7.85714C-0.00248656 9.55945 0.553566 11.2156 1.58287 12.5714C1.58287 12.5714 1.79715 12.8536 1.83215 12.8943L7.85715 20L13.885 12.8907C13.9164 12.8529 14.1314 12.5714 14.1314 12.5714L14.1322 12.5693C15.1609 11.214 15.7167 9.55866 15.7143 7.85714C15.7118 5.77405 14.8832 3.77699 13.4103 2.30402C11.9373 0.831051 9.94024 0.00245748 7.85715 0ZM7.85715 10.7143C7.29206 10.7143 6.73966 10.5467 6.26981 10.2328C5.79995 9.91882 5.43375 9.4726 5.2175 8.95052C5.00125 8.42845 4.94466 7.85397 5.05491 7.29974C5.16515 6.74551 5.43727 6.23642 5.83685 5.83684C6.23642 5.43726 6.74552 5.16514 7.29975 5.0549C7.85398 4.94466 8.42846 5.00124 8.95053 5.21749C9.47261 5.43374 9.91883 5.79994 10.2328 6.2698C10.5467 6.73965 10.7143 7.29205 10.7143 7.85714C10.7133 8.61461 10.412 9.34079 9.87641 9.8764C9.3408 10.412 8.61462 10.7133 7.85715 10.7143Z"/>
                        </svg>';
            break;
            
            case 'image':
                return '<svg width="16" height="12" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M13.25 0H2.75C2.15326 0 1.58097 0.237053 1.15901 0.65901C0.737053 1.08097 0.5 1.65326 0.5 2.25V9.75C0.5 10.3467 0.737053 10.919 1.15901 11.341C1.58097 11.7629 2.15326 12 2.75 12H13.25C13.8467 12 14.419 11.7629 14.841 11.341C15.2629 10.919 15.5 10.3467 15.5 9.75V2.25C15.5 1.65326 15.2629 1.08097 14.841 0.65901C14.419 0.237053 13.8467 0 13.25 0ZM2.75 10.5C2.55109 10.5 2.36032 10.421 2.21967 10.2803C2.07902 10.1397 2 9.94891 2 9.75V7.935L4.475 5.4675C4.6152 5.33008 4.80369 5.25311 5 5.25311C5.19631 5.25311 5.3848 5.33008 5.525 5.4675L10.5575 10.5H2.75ZM14 9.75C14 9.94891 13.921 10.1397 13.7803 10.2803C13.6397 10.421 13.4489 10.5 13.25 10.5H12.6725L9.815 7.6275L10.475 6.9675C10.6152 6.83008 10.8037 6.75311 11 6.75311C11.1963 6.75311 11.3848 6.83008 11.525 6.9675L14 9.435V9.75ZM14 7.32L12.59 5.9175C12.1625 5.50682 11.5928 5.27747 11 5.27747C10.4072 5.27747 9.83746 5.50682 9.41 5.9175L8.75 6.5775L6.59 4.4175C6.16254 4.00682 5.59277 3.77747 5 3.77747C4.40723 3.77747 3.83746 4.00682 3.41 4.4175L2 5.82V2.25C2 2.05109 2.07902 1.86032 2.21967 1.71967C2.36032 1.57902 2.55109 1.5 2.75 1.5H13.25C13.4489 1.5 13.6397 1.57902 13.7803 1.71967C13.921 1.86032 14 2.05109 14 2.25V7.32Z"/>
                </svg>';
            break;

            case 'video':
                return '<svg width="16" height="10" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15.1475 1.3625C15.0335 1.29667 14.9042 1.26202 14.7725 1.26202C14.6408 1.26202 14.5115 1.29667 14.3975 1.3625L11.75 2.6675C11.7286 2.08518 11.4822 1.53385 11.0625 1.12958C10.6429 0.725304 10.0827 0.499609 9.5 0.500001H2.75C2.15326 0.500001 1.58097 0.737053 1.15901 1.15901C0.737053 1.58097 0.5 2.15326 0.5 2.75V7.25C0.5 7.84674 0.737053 8.41903 1.15901 8.84099C1.58097 9.26295 2.15326 9.5 2.75 9.5H9.5C10.0827 9.50039 10.6429 9.2747 11.0625 8.87042C11.4822 8.46615 11.7286 7.91482 11.75 7.3325L14.42 8.6675C14.5222 8.71991 14.6351 8.74814 14.75 8.75C14.8904 8.75045 15.0281 8.71147 15.1475 8.6375C15.2556 8.56995 15.3447 8.47596 15.4063 8.36442C15.468 8.25288 15.5003 8.12746 15.5 8V2C15.5003 1.87254 15.468 1.74712 15.4063 1.63558C15.3447 1.52404 15.2556 1.43005 15.1475 1.3625ZM10.25 7.25C10.25 7.44891 10.171 7.63968 10.0303 7.78033C9.88968 7.92098 9.69891 8 9.5 8H2.75C2.55109 8 2.36032 7.92098 2.21967 7.78033C2.07902 7.63968 2 7.44891 2 7.25V2.75C2 2.55109 2.07902 2.36032 2.21967 2.21967C2.36032 2.07902 2.55109 2 2.75 2H9.5C9.69891 2 9.88968 2.07902 10.0303 2.21967C10.171 2.36032 10.25 2.55109 10.25 2.75V7.25ZM14 6.785L11.75 5.66V4.34L14 3.215V6.785Z" fill="#494D41"/>
                </svg>';
            break;

            default:
                # code...
                break;
            }
    }

    /**
     * List All Social Icons get theme mod function
     *
     * @return void
     */
    public function travel_monster_all_social_icons(){
        $social_array = [ 
            [
                'key' => 'tmp_facebook',
                'value' => '#'
            ],
            [
                'key' => 'tmp_twitter',
                'value' => '#'
            ],
            [
                'key' => 'tmp_instagram',
                'value' => '#'
            ],
            [
                'key' => 'tmp_pinterest',
                'value' => ''
            ],
            [
                'key' => 'tmp_youtube',
                'value' => ''
            ],
            [
                'key' => 'tmp_tiktok',
                'value' => ''
            ],
            [
                'key' => 'tmp_linkedin',
                'value' => ''
            ],
            [
                'key' => 'tmp_whatsapp',
                'value' => ''
            ],
            [
                'key' => 'tmp_viber',
                'value' => ''
            ],
            [
                'key' => 'tmp_telegram',
                'value' => ''
            ],
            [
                'key' => 'tmp_tripadvisor',
                'value' => ''
            ]
        ];
        $social_icons = apply_filters( 'tmp_social_icons',$social_array );
        if( ! $social_icons ) return;

        $list_social = [];
        foreach( $social_icons as $icon  ){
            $list_social[$icon['key']] = get_theme_mod( $icon['key'], $icon['value'] );
        }

        return $list_social;
    }

    /**
     * Social Links function
     *
     * @return void
     */
    public function travel_monster_social_links(){
        $defaults               = travel_monster_get_general_defaults();
        $ed_social_media        = get_theme_mod( 'ed_social_media', $defaults['ed_social_media'] );
        $ed_social_media_newtab = get_theme_mod( 'ed_social_media_newtab', $defaults['ed_social_media_newtab'] );

        $list_social            = $this->travel_monster_all_social_icons();
        $social_media_order     = get_theme_mod( 'social_media_order', $defaults['social_media_order']  );
        if( $ed_social_media && $social_media_order ){ ?>
                <ul class="social-networks">
                    <?php 
                    foreach( $social_media_order as $link ){
                        $actualsocialkey = str_replace( 'tmp_','',$link );
                        foreach( $list_social as $key => $value ){
                            if( !empty( $value ) && $key == $link ){
                                ?>
                                    <li>
                                    <a href="<?php if( isset( $value ) ) echo esc_url( $value ); ?>" target="<?php echo $ed_social_media_newtab ? '_blank': '_self'; ?>" rel="nofollow noopener">
                                        <?php echo wp_kses( $this->travel_monster_lists_all_svgs( $actualsocialkey ), travel_monster_get_kses_extended_ruleset() ); ?>
                                    </a>
                                </li>  
                                <?php 
                            }
                        }
                    } 
                    ?>
                </ul>
            <?php                            
        }
    }
}