<?php
/**
 * Duration Widget.
 *
 * @since 1.3.0
 * @package wptravelengine-elementor-widgets
 */

namespace WPTRAVELENGINEEB\Trip;

use WPTRAVELENGINEEB\Widget;
use WPTRAVELENGINEEB;

/**
 * Class Duration.
 *
 * @since 1.3.0
 */
class DurationWidget extends Widget {

	/**
	 * Widget name.
	 *
	 * @since 1.3.0
	 *
	 * @var string
	 */
	protected $widget_name = 'wte-duration';

	/**
	 * Widget categories.
	 *
	 * @since 1.3.0
	 *
	 * @var array
	 */
	protected $categories = array( 'wptravelengine' );

	/**
	 * Widget keywords.
	 *
	 * @since 1.3.0
	 *
	 * @var array
	 */
	protected $keywords = array( 'duration', 'wp travel engine', 'wte' );

	/**
	 * Set Widget Title.
	 *
	 * @since 1.3.0
	 */
	public function get_title() {
		return __( 'Trip - Duration', 'wptravelengine-elementor-widgets' );
	}

	/**
	 * Set Widget Icon.
	 *
	 * @since 1.3.0
	 */
	public function get_icon() {
		return 'eicon-calendar';
	}

	/**
	 * Widget Settings.
	 *
	 * @since 1.3.0
	 */
	protected function register_controls() {
		wp_enqueue_style( 'wte-fonts-style' );
		$settings = WPTRAVELENGINEEB\Widgets_Controller::instance()->get_core_widget_setting( $this->widget_name, 'controls' );
		$controls = isset( $settings['controls'] ) && is_array( $settings['controls'] ) ? $settings['controls'] : array();
		$this->_wte_add_controls( $settings );
		$controls = include WPTRAVELENGINEEB_PATH . 'includes/trip-widgets/duration/controls.php';
		$this->_wte_add_controls( $controls );
	}

	/**
	 * Renders Widget.
	 *
	 * @since 1.3.0
	 */
	protected function render() {
		$attributes               = $this->get_settings_for_display();
		$is_elementor_editor_page = $this->is_elementor_editor_page();
		$duration_exists          = $this->render_condition();
		if ( ! $duration_exists && $is_elementor_editor_page ) {
			include WPTRAVELENGINEEB_PATH . 'includes/trip-widgets/duration/demo.php';
		} elseif ( file_exists( WPTRAVELENGINEEB_PATH . 'includes/trip-widgets/duration/duration.php' ) ) {
			include WPTRAVELENGINEEB_PATH . 'includes/trip-widgets/duration/duration.php';
		} else {
			echo esc_html__( '<p>Oops! No preview/output available for this widget.</p>', 'wptravelengine-elementor-widgets' );
		}
	}

	/**
	 * Render Condition.
	 *
	 * @since 1.3.0
	 */
	protected function render_condition() {
		global $post;
		$post_meta = get_post_meta( $post->ID, 'wp_travel_engine_setting', true );
		$duration  = isset( $post_meta['trip_duration'] ) && '' !== $post_meta['trip_duration'] ? $post_meta['trip_duration'] : '';

		return ! empty( $duration );
	}
}
