/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/components/FavButton/FavButton.jsx":
/*!************************************************!*\
  !*** ./src/components/FavButton/FavButton.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon.jsx");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




function FavButton({
  icon,
  handleClick
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "cw-pattern-library__design-fav transform-scale",
    onClick: handleClick,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Favourite', 'cw-pattern-import')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
    icon: icon
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FavButton);

/***/ }),

/***/ "./src/components/Icon.jsx":
/*!*********************************!*\
  !*** ./src/components/Icon.jsx ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const icons = {
  logo: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "236",
    height: "32",
    viewBox: "0 0 236 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M63.02 22.8L58.95 7.39999H61.964L64.736 19.654L67.992 7.39999H71.094L74.262 19.654L77.034 7.39999H80.07L75.89 22.8H72.546L69.488 11.382L66.342 22.8H63.02ZM81.6708 22.8V7.39999L87.3688 7.39999C88.6008 7.39999 89.6202 7.60532 90.4268 8.01599C91.2335 8.42665 91.8348 8.99132 92.2308 9.70999C92.6268 10.4287 92.8248 11.2353 92.8248 12.13C92.8248 12.9807 92.6342 13.7653 92.2528 14.484C91.8715 15.188 91.2775 15.76 90.4708 16.2C89.6642 16.6253 88.6302 16.838 87.3688 16.838H84.4868V22.8H81.6708ZM84.4868 14.55H87.1928C88.1755 14.55 88.8795 14.3373 89.3048 13.912C89.7448 13.472 89.9648 12.878 89.9648 12.13C89.9648 11.3673 89.7448 10.7733 89.3048 10.348C88.8795 9.90799 88.1755 9.68799 87.1928 9.68799H84.4868V14.55Z",
    fill: "#3F494B"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M102.982 22.8V9.66599H98.4943V7.39999H110.308V9.66599L105.798 9.66599V22.8H102.982ZM110.814 22.8V11.888H113.322L113.586 13.934C113.982 13.23 114.517 12.6727 115.192 12.262C115.881 11.8367 116.688 11.624 117.612 11.624V14.594H116.82C116.204 14.594 115.654 14.6893 115.17 14.88C114.686 15.0707 114.305 15.4007 114.026 15.87C113.762 16.3393 113.63 16.992 113.63 17.828V22.8H110.814ZM122.859 23.064C121.92 23.064 121.15 22.9173 120.549 22.624C119.947 22.316 119.5 21.9127 119.207 21.414C118.913 20.9153 118.767 20.3653 118.767 19.764C118.767 18.752 119.163 17.9307 119.955 17.3C120.747 16.6693 121.935 16.354 123.519 16.354H126.291V16.09C126.291 15.342 126.078 14.792 125.653 14.44C125.227 14.088 124.699 13.912 124.069 13.912C123.497 13.912 122.998 14.0513 122.573 14.33C122.147 14.594 121.883 14.99 121.781 15.518H119.031C119.104 14.726 119.368 14.0367 119.823 13.45C120.292 12.8633 120.893 12.416 121.627 12.108C122.36 11.7853 123.181 11.624 124.091 11.624C125.645 11.624 126.87 12.0127 127.765 12.79C128.659 13.5673 129.107 14.6673 129.107 16.09V22.8H126.709L126.445 21.04C126.122 21.6267 125.667 22.1107 125.081 22.492C124.509 22.8733 123.768 23.064 122.859 23.064ZM123.497 20.864C124.303 20.864 124.927 20.6 125.367 20.072C125.821 19.544 126.107 18.8913 126.225 18.114H123.827C123.079 18.114 122.543 18.2533 122.221 18.532C121.898 18.796 121.737 19.126 121.737 19.522C121.737 19.9473 121.898 20.2773 122.221 20.512C122.543 20.7467 122.969 20.864 123.497 20.864ZM133.98 22.8L129.976 11.888H132.924L135.696 20.138L138.468 11.888H141.416L137.39 22.8H133.98ZM147.517 23.064C146.417 23.064 145.442 22.8293 144.591 22.36C143.74 21.8907 143.073 21.2307 142.589 20.38C142.105 19.5293 141.863 18.5467 141.863 17.432C141.863 16.3027 142.098 15.298 142.567 14.418C143.051 13.538 143.711 12.856 144.547 12.372C145.398 11.8733 146.395 11.624 147.539 11.624C148.61 11.624 149.556 11.8587 150.377 12.328C151.198 12.7973 151.836 13.4427 152.291 14.264C152.76 15.0707 152.995 15.9727 152.995 16.97C152.995 17.1313 152.988 17.3 152.973 17.476C152.973 17.652 152.966 17.8353 152.951 18.026H144.657C144.716 18.8767 145.009 19.544 145.537 20.028C146.08 20.512 146.732 20.754 147.495 20.754C148.067 20.754 148.544 20.6293 148.925 20.38C149.321 20.116 149.614 19.7787 149.805 19.368H152.665C152.46 20.0573 152.115 20.688 151.631 21.26C151.162 21.8173 150.575 22.2573 149.871 22.58C149.182 22.9027 148.397 23.064 147.517 23.064ZM147.539 13.912C146.85 13.912 146.241 14.11 145.713 14.506C145.185 14.8873 144.848 15.474 144.701 16.266H150.135C150.091 15.5473 149.827 14.9753 149.343 14.55C148.859 14.1247 148.258 13.912 147.539 13.912ZM154.923 22.8V6.95999H157.739V22.8H154.923ZM165.045 22.8V7.39999H175.099V9.66599L167.861 9.66599V13.89L174.439 13.89V16.09H167.861V20.534H175.099V22.8H165.045ZM177.258 22.8V11.888H179.744L179.964 13.736C180.301 13.0907 180.785 12.5773 181.416 12.196C182.061 11.8147 182.816 11.624 183.682 11.624C185.031 11.624 186.08 12.0493 186.828 12.9C187.576 13.7507 187.95 14.9973 187.95 16.64V22.8H185.134V16.904C185.134 15.9653 184.943 15.2467 184.562 14.748C184.18 14.2493 183.586 14 182.78 14C181.988 14 181.335 14.2787 180.822 14.836C180.323 15.3933 180.074 16.1707 180.074 17.168V22.8H177.258ZM194.822 19.544C194.294 19.544 193.803 19.4853 193.348 19.368L192.534 20.182C192.784 20.314 193.121 20.424 193.546 20.512C193.972 20.6 194.661 20.688 195.614 20.776C197.066 20.908 198.122 21.2527 198.782 21.81C199.442 22.3673 199.772 23.1373 199.772 24.12C199.772 24.7653 199.596 25.374 199.244 25.946C198.892 26.5327 198.35 27.002 197.616 27.354C196.883 27.7207 195.944 27.904 194.8 27.904C193.246 27.904 191.992 27.6107 191.038 27.024C190.085 26.452 189.608 25.5867 189.608 24.428C189.608 23.4453 190.085 22.5947 191.038 21.876C190.745 21.744 190.488 21.6047 190.268 21.458C190.063 21.3113 189.88 21.1573 189.718 20.996V20.49L191.632 18.466C190.782 17.718 190.356 16.7573 190.356 15.584C190.356 14.8507 190.532 14.1833 190.884 13.582C191.251 12.9807 191.764 12.504 192.424 12.152C193.084 11.8 193.884 11.624 194.822 11.624C195.438 11.624 196.01 11.712 196.538 11.888H200.674V13.604L198.804 13.736C199.098 14.2933 199.244 14.9093 199.244 15.584C199.244 16.3173 199.068 16.9847 198.716 17.586C198.364 18.1873 197.851 18.664 197.176 19.016C196.516 19.368 195.732 19.544 194.822 19.544ZM194.822 17.388C195.394 17.388 195.864 17.234 196.23 16.926C196.612 16.618 196.802 16.178 196.802 15.606C196.802 15.034 196.612 14.594 196.23 14.286C195.864 13.978 195.394 13.824 194.822 13.824C194.221 13.824 193.737 13.978 193.37 14.286C193.004 14.594 192.82 15.034 192.82 15.606C192.82 16.178 193.004 16.618 193.37 16.926C193.737 17.234 194.221 17.388 194.822 17.388ZM192.182 24.142C192.182 24.6847 192.432 25.088 192.93 25.352C193.444 25.6307 194.067 25.77 194.8 25.77C195.504 25.77 196.076 25.6233 196.516 25.33C196.956 25.0513 197.176 24.67 197.176 24.186C197.176 23.79 197.03 23.46 196.736 23.196C196.458 22.932 195.893 22.7707 195.042 22.712C194.441 22.668 193.884 22.602 193.37 22.514C192.945 22.7487 192.637 23.0053 192.446 23.284C192.27 23.5627 192.182 23.8487 192.182 24.142ZM203.806 10.194C203.292 10.194 202.867 10.04 202.53 9.73199C202.207 9.42399 202.046 9.03532 202.046 8.56599C202.046 8.09665 202.207 7.71532 202.53 7.42199C202.867 7.11399 203.292 6.95999 203.806 6.95999C204.319 6.95999 204.737 7.11399 205.06 7.42199C205.397 7.71532 205.566 8.09665 205.566 8.56599C205.566 9.03532 205.397 9.42399 205.06 9.73199C204.737 10.04 204.319 10.194 203.806 10.194ZM202.398 22.8V11.888L205.214 11.888V22.8H202.398ZM207.713 22.8V11.888H210.199L210.419 13.736C210.756 13.0907 211.24 12.5773 211.871 12.196C212.516 11.8147 213.272 11.624 214.137 11.624C215.486 11.624 216.535 12.0493 217.283 12.9C218.031 13.7507 218.405 14.9973 218.405 16.64V22.8L215.589 22.8V16.904C215.589 15.9653 215.398 15.2467 215.017 14.748C214.636 14.2493 214.042 14 213.235 14C212.443 14 211.79 14.2787 211.277 14.836C210.778 15.3933 210.529 16.1707 210.529 17.168V22.8H207.713ZM225.96 23.064C224.86 23.064 223.884 22.8293 223.034 22.36C222.183 21.8907 221.516 21.2307 221.032 20.38C220.548 19.5293 220.306 18.5467 220.306 17.432C220.306 16.3027 220.54 15.298 221.01 14.418C221.494 13.538 222.154 12.856 222.99 12.372C223.84 11.8733 224.838 11.624 225.982 11.624C227.052 11.624 227.998 11.8587 228.82 12.328C229.641 12.7973 230.279 13.4427 230.734 14.264C231.203 15.0707 231.438 15.9727 231.438 16.97C231.438 17.1313 231.43 17.3 231.416 17.476C231.416 17.652 231.408 17.8353 231.394 18.026H223.1C223.158 18.8767 223.452 19.544 223.98 20.028C224.522 20.512 225.175 20.754 225.938 20.754C226.51 20.754 226.986 20.6293 227.368 20.38C227.764 20.116 228.057 19.7787 228.248 19.368H231.108C230.902 20.0573 230.558 20.688 230.074 21.26C229.604 21.8173 229.018 22.2573 228.314 22.58C227.624 22.9027 226.84 23.064 225.96 23.064ZM225.982 13.912C225.292 13.912 224.684 14.11 224.156 14.506C223.628 14.8873 223.29 15.474 223.144 16.266H228.578C228.534 15.5473 228.27 14.9753 227.786 14.55C227.302 14.1247 226.7 13.912 225.982 13.912Z",
    fill: "url(#paint0_linear_79544_989)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_79544_989)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M49.2668 16.2806C49.9401 15.2745 48.9377 14.4265 48.9377 14.4265C48.9377 14.4265 47.7677 13.8324 47.0975 14.8385C46.4242 15.8447 44.7276 18.3885 44.7276 18.3885L37.8067 18.5497L36.6457 20.2873L42.5224 21.6876L39.8863 24.8643C40.7061 25.1838 41.4033 25.7719 42.1932 26.166L44.6917 23.1296L48.2495 28.0022L49.4104 26.2646L46.894 19.8305C46.897 19.8305 48.5966 17.2868 49.2668 16.2806Z",
    fill: "#3F494B"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.5749 14.8505C26.6654 14.8505 28.3601 13.1596 28.3601 11.0737C28.3601 8.98782 26.6654 7.29688 24.5749 7.29688C22.4845 7.29688 20.7898 8.98782 20.7898 11.0737C20.7898 13.1596 22.4845 14.8505 24.5749 14.8505Z",
    fill: "url(#paint1_linear_79544_989)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M45.5354 19.2484C44.907 18.8543 44.0752 19.0424 43.6802 19.6723C39.8323 25.769 35.8137 29.101 32.0585 29.304C27.3039 29.5667 24.1741 24.9479 21.4422 21.8638C19.994 20.2277 18.6774 18.4811 17.5284 16.624C16.6188 15.1581 15.6134 13.4055 15.6134 11.632C15.6104 6.69976 19.6319 2.68707 24.575 2.68707C29.5152 2.68707 33.5367 6.69976 33.5367 11.632C33.5367 14.5848 29.976 19.3141 26.9179 22.7654C26.4362 23.3088 26.49 24.1358 27.0257 24.6285C27.0346 24.6344 27.0406 24.6434 27.0496 24.6494C27.5942 25.151 28.4499 25.1032 28.9407 24.5508C32.1004 21.0069 36.2327 15.6119 36.2327 11.629C36.2297 5.2159 31.0023 0 24.575 0C18.1478 0 12.9174 5.2159 12.9174 11.632C12.9174 15.379 16.5769 20.3769 19.6499 23.9149L19.6409 23.906C20.4548 24.6733 21.1549 25.6018 21.9239 26.4169C23.4171 27.9933 24.9431 29.6742 26.8611 30.7311C26.8641 30.7341 26.8701 30.7341 26.882 30.743C28.1657 31.4417 29.7845 32 31.6815 32C31.8401 32 32.0017 31.997 32.1663 31.9881C36.9089 31.7522 41.5498 28.0888 45.9573 21.1024C46.3553 20.4755 46.1638 19.6455 45.5354 19.2484Z",
    fill: "#3F494B"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.6786 28.9967C21.2866 28.6265 20.7121 28.5339 20.2154 28.7429C19.3178 29.1191 18.2675 29.3699 17.0916 29.3042C13.3364 29.1012 9.31783 25.7692 5.48482 19.6935L2.4986 14.7582C2.1156 14.1223 1.28676 13.9193 0.652412 14.3014C0.0150733 14.6866 -0.191389 15.5106 0.194605 16.1466L3.19279 21.1027C7.6003 28.0891 12.2412 31.7524 16.9838 31.9883C17.1484 31.9973 17.31 32.0003 17.4686 32.0003C18.9018 32.0003 20.1795 31.6808 21.2717 31.221C22.1723 30.8418 22.3937 29.6715 21.6846 28.9997L21.6786 28.9967Z",
    fill: "url(#paint2_linear_79544_989)"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_79544_989",
    x1: "10.9454",
    y1: "-3.68183",
    x2: "27.1675",
    y2: "83.9744",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00A89F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint1_linear_79544_989",
    x1: "18.7252",
    y1: "6.12949",
    x2: "30.4703",
    y2: "16.7303",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00A89F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint2_linear_79544_989",
    x1: "-6.02864",
    y1: "11.3435",
    x2: "21.7788",
    y2: "42.2838",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00A89F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_79544_989"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "49.5",
    height: "32",
    fill: "white"
  })))),
  col2: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 4.44133C11 3.64533 10.3547 3 9.55867 3H4.44133C3.64533 3 3 3.64533 3 4.44133V9.55867C3 10.3547 3.64533 11 4.44133 11H9.55867C10.3547 11 11 10.3547 11 9.55867V4.44133Z",
    fill: "currentColor"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21 4.44133C21 3.64533 20.3547 3 19.5587 3H14.4413C13.6453 3 13 3.64533 13 4.44133V9.55867C13 10.3547 13.6453 11 14.4413 11H19.5587C20.3547 11 21 10.3547 21 9.55867V4.44133Z",
    fill: "currentColor"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 14.4413C11 13.6453 10.3547 13 9.55867 13H4.44133C3.64533 13 3 13.6453 3 14.4413V19.5587C3 20.3547 3.64533 21 4.44133 21H9.55867C10.3547 21 11 20.3547 11 19.5587V14.4413Z",
    fill: "currentColor"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21 14.4413C21 13.6453 20.3547 13 19.5587 13H14.4413C13.6453 13 13 13.6453 13 14.4413V19.5587C13 20.3547 13.6453 21 14.4413 21H19.5587C20.3547 21 21 20.3547 21 19.5587V14.4413Z",
    fill: "currentColor"
  })),
  col3: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M20.1819 9.54552H16.9091C16.091 9.54552 16.091 9.54552 16.091 10.3636V13.6364C16.091 14.4545 16.091 14.4545 16.9091 14.4545H20.1819C21 14.4545 21 14.4545 21 13.6364V10.3636C21 9.54552 21 9.54552 20.1819 9.54552ZM13.6364 3H10.3636C9.54552 3 9.54552 3 9.54552 3.8181V7.09086C9.54552 7.90896 9.54552 7.90896 10.3636 7.90896H13.6364C14.4545 7.90896 14.4545 7.90896 14.4545 7.09086V3.8181C14.4545 3 14.4545 3 13.6364 3ZM20.1819 16.0909H16.9091C16.091 16.0909 16.091 16.0909 16.091 16.909V20.1817C16.091 20.9998 16.091 20.9998 16.9091 20.9998H20.1819C21 21 21 21 21 20.1819V16.9091C21 16.0909 21 16.0909 20.1819 16.0909ZM13.6364 9.54552H10.3636C9.54552 9.54552 9.54552 9.54552 9.54552 10.3636V13.6364C9.54552 14.4545 9.54552 14.4545 10.3636 14.4545H13.6364C14.4545 14.4545 14.4545 14.4545 14.4545 13.6364V10.3636C14.4545 9.54552 14.4545 9.54552 13.6364 9.54552ZM7.09086 3H3.8181C3 3 3 3 3 3.8181V7.09086C3 7.90896 3 7.90896 3.8181 7.90896H7.09086C7.90896 7.90896 7.90896 7.90896 7.90896 7.09086V3.8181C7.90914 3 7.90914 3 7.09086 3ZM13.6364 16.0909H10.3636C9.54552 16.0909 9.54552 16.0909 9.54552 16.909V20.1817C9.54552 20.9998 9.54552 20.9998 10.3636 20.9998H13.6364C14.4545 20.9998 14.4545 20.9998 14.4545 20.1817V16.9091C14.4545 16.0909 14.4545 16.0909 13.6364 16.0909ZM7.09086 9.54552H3.8181C3 9.54552 3 9.54552 3 10.3636V13.6364C3 14.4545 3 14.4545 3.8181 14.4545H7.09086C7.90896 14.4545 7.90896 14.4545 7.90896 13.6364V10.3636C7.90914 9.54552 7.90914 9.54552 7.09086 9.54552ZM7.09086 16.0909H3.8181C3 16.0909 3 16.0909 3 16.9091V20.1819C3 21 3 21 3.8181 21H7.09086C7.90896 21 7.90896 21 7.90896 20.1819V16.9091C7.90914 16.0909 7.90914 16.0909 7.09086 16.0909ZM20.1819 3H16.9091C16.091 3 16.091 3 16.091 3.8181V7.09086C16.091 7.90896 16.091 7.90896 16.9091 7.90896H20.1819C21 7.90896 21 7.90896 21 7.09086V3.8181C21 3 21 3 20.1819 3Z",
    fill: "currentColor"
  })),
  sync: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    opacity: "0.6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2 14C2 14 2.12132 14.8492 5.63604 18.364C9.15076 21.8787 14.8492 21.8787 18.364 18.364C19.6092 17.1187 20.4133 15.5993 20.7762 14M2 14V20M2 14H8M22 10C22 10 21.8787 9.15076 18.364 5.63604C14.8492 2.12132 9.15076 2.12132 5.63604 5.63604C4.39076 6.88131 3.58669 8.40072 3.22383 10M22 10V4M22 10H16",
    stroke: "currentColor",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }))),
  crown: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "14",
    viewBox: "0 0 16 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.16667 10.3333L0.5 1.16666L5.08333 5.33333L8 0.333328L10.9167 5.33333L15.5 1.16666L13.8333 10.3333H2.16667ZM13.8333 12.8333C13.8333 13.3333 13.5 13.6667 13 13.6667H3C2.5 13.6667 2.16667 13.3333 2.16667 12.8333V12H13.8333V12.8333Z",
    fill: "white"
  })),
  img: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_79546_11888)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.00299 8.25C9.00299 8.84674 8.76594 9.41903 8.34398 9.84099C7.92202 10.2629 7.34973 10.5 6.75299 10.5C6.15625 10.5 5.58396 10.2629 5.162 9.84099C4.74004 9.41903 4.50299 8.84674 4.50299 8.25C4.50299 7.65326 4.74004 7.08097 5.162 6.65901C5.58396 6.23705 6.15625 6 6.75299 6C7.34973 6 7.92202 6.23705 8.34398 6.65901C8.76594 7.08097 9.00299 7.65326 9.00299 8.25Z",
    fill: "#0CB19F"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.00299 1.5C2.20734 1.5 1.44428 1.81607 0.88167 2.37868C0.319061 2.94129 0.00299072 3.70435 0.00299072 4.5V19.5C0.00299072 20.2956 0.319061 21.0587 0.88167 21.6213C1.44428 22.1839 2.20734 22.5 3.00299 22.5H21.003C21.7986 22.5 22.5617 22.1839 23.1243 21.6213C23.6869 21.0587 24.003 20.2956 24.003 19.5V4.5C24.003 3.70435 23.6869 2.94129 23.1243 2.37868C22.5617 1.81607 21.7986 1.5 21.003 1.5H3.00299ZM21.003 3C21.4008 3 21.7823 3.15804 22.0637 3.43934C22.345 3.72064 22.503 4.10218 22.503 4.5V14.25L16.8375 11.3295C16.6968 11.259 16.5376 11.2346 16.3822 11.2596C16.2269 11.2847 16.0834 11.3579 15.972 11.469L10.407 17.034L6.41699 14.376C6.27293 14.2801 6.10013 14.237 5.9279 14.2539C5.75566 14.2709 5.59459 14.3468 5.47199 14.469L1.50299 18V4.5C1.50299 4.10218 1.66103 3.72064 1.94233 3.43934C2.22364 3.15804 2.60517 3 3.00299 3H21.003Z",
    fill: "#0CB19F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_79546_11888"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "24",
    height: "24",
    fill: "white"
  })))),
  down_arrow: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "16",
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8 2C8.26522 2 8.51957 2.10536 8.70711 2.29289C8.89464 2.48043 9 2.73478 9 3V10.92L11.6267 8.29333C11.8162 8.11669 12.067 8.02053 12.326 8.0251C12.5851 8.02967 12.8323 8.13462 13.0155 8.31784C13.1987 8.50105 13.3037 8.74824 13.3082 9.0073C13.3128 9.26637 13.2166 9.5171 13.04 9.70667L8.70667 14.04C8.51917 14.2273 8.265 14.3325 8 14.3325C7.735 14.3325 7.48083 14.2273 7.29333 14.04L2.96 9.70667C2.86175 9.61512 2.78295 9.50472 2.72829 9.38205C2.67364 9.25939 2.64425 9.12697 2.64188 8.9927C2.63951 8.85843 2.66421 8.72505 2.7145 8.60054C2.7648 8.47602 2.83966 8.36291 2.93462 8.26795C3.02958 8.17299 3.14269 8.09813 3.2672 8.04784C3.39172 7.99754 3.52509 7.97284 3.65936 7.97521C3.79364 7.97758 3.92605 8.00697 4.04872 8.06163C4.17138 8.11628 4.28179 8.19508 4.37333 8.29333L7 10.92V3C7 2.73478 7.10536 2.48043 7.29289 2.29289C7.48043 2.10536 7.73478 2 8 2Z",
    fill: "white"
  })),
  heart_fill: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("mask", {
    id: "mask0_79550_12144",
    style: {
      maskType: 'alpha'
    },
    maskUnits: "userSpaceOnUse",
    x: "0",
    y: "0",
    width: "20",
    height: "20"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "#D9D9D9"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    mask: "url(#mask0_79550_12144)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 18.6457L8.79199 17.5623C7.38921 16.2984 6.22949 15.2082 5.31283 14.2915C4.39616 13.3748 3.66699 12.5519 3.12533 11.8228C2.58366 11.0936 2.20519 10.4234 1.98991 9.81234C1.77463 9.20123 1.66699 8.57623 1.66699 7.93734C1.66699 6.63178 2.10449 5.5415 2.97949 4.6665C3.85449 3.7915 4.94477 3.354 6.25033 3.354C6.97255 3.354 7.66005 3.50678 8.31283 3.81234C8.9656 4.11789 9.5281 4.54845 10.0003 5.104C10.4725 4.54845 11.035 4.11789 11.6878 3.81234C12.3406 3.50678 13.0281 3.354 13.7503 3.354C15.0559 3.354 16.1462 3.7915 17.0212 4.6665C17.8962 5.5415 18.3337 6.63178 18.3337 7.93734C18.3337 8.57623 18.226 9.20123 18.0107 9.81234C17.7955 10.4234 17.417 11.0936 16.8753 11.8228C16.3337 12.5519 15.6045 13.3748 14.6878 14.2915C13.7712 15.2082 12.6114 16.2984 11.2087 17.5623L10.0003 18.6457Z",
    fill: "currentColor"
  }))),
  heart_outline: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("mask", {
    id: "mask0_79550_12139",
    style: {
      maskType: 'alpha'
    },
    maskUnits: "userSpaceOnUse",
    x: "0",
    y: "0",
    width: "20",
    height: "20"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "#D9D9D9"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    mask: "url(#mask0_79550_12139)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 18.6457L8.79199 17.5623C7.38921 16.2984 6.22949 15.2082 5.31283 14.2915C4.39616 13.3748 3.66699 12.5519 3.12533 11.8228C2.58366 11.0936 2.20519 10.4234 1.98991 9.81234C1.77463 9.20123 1.66699 8.57623 1.66699 7.93734C1.66699 6.63178 2.10449 5.5415 2.97949 4.6665C3.85449 3.7915 4.94477 3.354 6.25033 3.354C6.97255 3.354 7.66005 3.50678 8.31283 3.81234C8.9656 4.11789 9.5281 4.54845 10.0003 5.104C10.4725 4.54845 11.035 4.11789 11.6878 3.81234C12.3406 3.50678 13.0281 3.354 13.7503 3.354C15.0559 3.354 16.1462 3.7915 17.0212 4.6665C17.8962 5.5415 18.3337 6.63178 18.3337 7.93734C18.3337 8.57623 18.226 9.20123 18.0107 9.81234C17.7955 10.4234 17.417 11.0936 16.8753 11.8228C16.3337 12.5519 15.6045 13.3748 14.6878 14.2915C13.7712 15.2082 12.6114 16.2984 11.2087 17.5623L10.0003 18.6457ZM10.0003 16.3957C11.3337 15.2012 12.4309 14.1769 13.292 13.3228C14.1531 12.4686 14.8337 11.7255 15.3337 11.0936C15.8337 10.4616 16.1809 9.89914 16.3753 9.40609C16.5698 8.91303 16.667 8.42345 16.667 7.93734C16.667 7.104 16.3892 6.40956 15.8337 5.854C15.2781 5.29845 14.5837 5.02067 13.7503 5.02067C13.0975 5.02067 12.4934 5.2047 11.9378 5.57275C11.3823 5.94081 11.0003 6.40956 10.792 6.979H9.20866C9.00033 6.40956 8.61838 5.94081 8.06283 5.57275C7.50727 5.2047 6.9031 5.02067 6.25033 5.02067C5.41699 5.02067 4.72255 5.29845 4.16699 5.854C3.61144 6.40956 3.33366 7.104 3.33366 7.93734C3.33366 8.42345 3.43088 8.91303 3.62533 9.40609C3.81977 9.89914 4.16699 10.4616 4.66699 11.0936C5.16699 11.7255 5.84755 12.4686 6.70866 13.3228C7.56977 14.1769 8.66699 15.2012 10.0003 16.3957Z",
    fill: "currentColor"
  }))),
  error: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "66",
    height: "66",
    viewBox: "0 0 66 66",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "9",
    y: "9",
    width: "48",
    height: "48",
    rx: "24",
    fill: "#D92D20",
    fillOpacity: "0.2"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M33.4761 28.6762V33.4762M33.4761 38.2762H33.4881M45.4761 33.4762C45.4761 40.1036 40.1035 45.4762 33.4761 45.4762C26.8487 45.4762 21.4761 40.1036 21.4761 33.4762C21.4761 26.8488 26.8487 21.4762 33.4761 21.4762C40.1035 21.4762 45.4761 26.8488 45.4761 33.4762Z",
    stroke: "#D92D20",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "4.85714",
    y: "4.85714",
    width: "56.2857",
    height: "56.2857",
    rx: "28.1429",
    stroke: "#D92D20",
    strokeOpacity: "0.1",
    strokeWidth: "8.28571"
  })),
  desktop: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "21",
    height: "20",
    viewBox: "0 0 21 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.16666 17.5H13.8333M10.5 14.1667V17.5M6.16666 14.1667H14.8333C16.2335 14.1667 16.9335 14.1667 17.4683 13.8942C17.9387 13.6545 18.3212 13.272 18.5608 12.8016C18.8333 12.2669 18.8333 11.5668 18.8333 10.1667V6.5C18.8333 5.09987 18.8333 4.3998 18.5608 3.86502C18.3212 3.39462 17.9387 3.01217 17.4683 2.77248C16.9335 2.5 16.2335 2.5 14.8333 2.5H6.16666C4.76652 2.5 4.06646 2.5 3.53168 2.77248C3.06127 3.01217 2.67882 3.39462 2.43914 3.86502C2.16666 4.3998 2.16666 5.09987 2.16666 6.5V10.1667C2.16666 11.5668 2.16666 12.2669 2.43914 12.8016C2.67882 13.272 3.06127 13.6545 3.53168 13.8942C4.06646 14.1667 4.76652 14.1667 6.16666 14.1667Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  tablet: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "21",
    height: "20",
    viewBox: "0 0 21 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.5 14.5834H10.5083M6.50001 18.3334H14.5C15.4334 18.3334 15.9001 18.3334 16.2567 18.1517C16.5703 17.9919 16.8252 17.7369 16.985 17.4233C17.1667 17.0668 17.1667 16.6001 17.1667 15.6667V4.33335C17.1667 3.39993 17.1667 2.93322 16.985 2.5767C16.8252 2.2631 16.5703 2.00813 16.2567 1.84834C15.9001 1.66669 15.4334 1.66669 14.5 1.66669H6.50001C5.56659 1.66669 5.09988 1.66669 4.74336 1.84834C4.42976 2.00813 4.17479 2.2631 4.015 2.5767C3.83334 2.93322 3.83334 3.39993 3.83334 4.33335V15.6667C3.83334 16.6001 3.83334 17.0668 4.015 17.4233C4.17479 17.7369 4.42976 17.9919 4.74336 18.1517C5.09988 18.3334 5.56659 18.3334 6.50001 18.3334ZM10.9167 14.5834C10.9167 14.8135 10.7301 15 10.5 15C10.2699 15 10.0833 14.8135 10.0833 14.5834C10.0833 14.3532 10.2699 14.1667 10.5 14.1667C10.7301 14.1667 10.9167 14.3532 10.9167 14.5834Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  mobile: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "21",
    height: "20",
    viewBox: "0 0 21 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.5 14.4H10.5071M7.78571 18H13.2143C14.0144 18 14.4144 18 14.72 17.8256C14.9888 17.6722 15.2073 17.4274 15.3443 17.1264C15.5 16.7841 15.5 16.3361 15.5 15.44V4.56C15.5 3.66392 15.5 3.21587 15.3443 2.87362C15.2073 2.57256 14.9888 2.32779 14.72 2.17439C14.4144 2 14.0144 2 13.2143 2H7.78571C6.98564 2 6.5856 2 6.28001 2.17439C6.01121 2.32779 5.79267 2.57256 5.6557 2.87362C5.5 3.21587 5.5 3.66392 5.5 4.56V15.44C5.5 16.3361 5.5 16.7841 5.6557 17.1264C5.79267 17.4274 6.01121 17.6722 6.28001 17.8256C6.5856 18 6.98564 18 7.78571 18ZM10.8571 14.4C10.8571 14.6209 10.6972 14.8 10.5 14.8C10.3028 14.8 10.1429 14.6209 10.1429 14.4C10.1429 14.1791 10.3028 14 10.5 14C10.6972 14 10.8571 14.1791 10.8571 14.4Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  back: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M15.8337 9.99996H4.16699M4.16699 9.99996L10.0003 15.8333M4.16699 9.99996L10.0003 4.16663",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  eye: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M30 24C30 25.5913 29.3679 27.1174 28.2426 28.2426C27.1174 29.3679 25.5913 30 24 30C22.4087 30 20.8826 29.3679 19.7574 28.2426C18.6321 27.1174 18 25.5913 18 24C18 22.4087 18.6321 20.8826 19.7574 19.7574C20.8826 18.6321 22.4087 18 24 18C25.5913 18 27.1174 18.6321 28.2426 19.7574C29.3679 20.8826 30 22.4087 30 24Z",
    stroke: "currentColor",
    strokeOpacity: "1",
    strokeWidth: "3",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M4 24C7.2 15.806 14.672 10 24 10C33.328 10 40.8 15.806 44 24C40.8 32.194 33.328 38 24 38C14.672 38 7.2 32.194 4 24Z",
    stroke: "currentColor",
    strokeOpacity: "1",
    strokeWidth: "3",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  'wp-travel-engine-white': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "15",
    viewBox: "0 0 24 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_79906_35)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M23.8869 7.63155C24.2133 7.15991 23.7273 6.76245 23.7273 6.76245C23.7273 6.76245 23.1601 6.48395 22.8351 6.95558C22.5087 7.42722 21.6861 8.6196 21.6861 8.6196L18.3305 8.69518L17.7676 9.50969L20.6169 10.1661L19.3388 11.6551C19.7363 11.8049 20.0743 12.0806 20.4573 12.2653L21.6687 10.842L23.3936 13.126L23.9565 12.3115L22.7364 9.29557C22.7379 9.29557 23.5619 8.10318 23.8869 7.63155Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.9152 6.96118C12.9287 6.96118 13.7504 6.16855 13.7504 5.1908C13.7504 4.21304 12.9287 3.42041 11.9152 3.42041C10.9016 3.42041 10.08 4.21304 10.08 5.1908C10.08 6.16855 10.9016 6.96118 11.9152 6.96118Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M22.2373 9.0881C21.9326 8.90337 21.5293 8.99154 21.3378 9.28683C19.4721 12.1446 17.5237 13.7065 15.703 13.8017C13.3978 13.9248 11.8803 11.7598 10.5557 10.3141C9.85354 9.54714 9.21521 8.72843 8.65811 7.85793C8.21708 7.17077 7.72962 6.34925 7.72962 5.51794C7.72817 3.20594 9.678 1.32499 12.0747 1.32499C14.4699 1.32499 16.4197 3.20594 16.4197 5.51794C16.4197 6.90206 14.6933 9.11889 13.2106 10.7367C12.977 10.9914 13.0032 11.3791 13.2628 11.61C13.2672 11.6128 13.2701 11.617 13.2744 11.6198C13.5385 11.8549 13.9534 11.8326 14.1913 11.5736C15.7233 9.91242 17.7268 7.38349 17.7268 5.51654C17.7254 2.51038 15.1909 0.0654297 12.0747 0.0654297C8.95842 0.0654297 6.42249 2.51038 6.42249 5.51794C6.42249 7.27433 8.19677 9.61712 9.68671 11.2755L9.68235 11.2713C10.077 11.631 10.4164 12.0663 10.7893 12.4483C11.5132 13.1873 12.2531 13.9752 13.183 14.4706C13.1845 14.472 13.1874 14.472 13.1932 14.4762C13.8156 14.8037 14.6004 15.0654 15.5202 15.0654C15.5971 15.0654 15.6755 15.064 15.7553 15.0598C18.0547 14.9493 20.3048 13.2321 22.4418 9.9572C22.6348 9.6633 22.5419 9.27424 22.2373 9.0881Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.5108 13.5922C10.3208 13.4187 10.0422 13.3753 9.80142 13.4733C9.36619 13.6496 8.85697 13.7672 8.28682 13.7364C6.46611 13.6412 4.51773 12.0793 2.65931 9.23133L1.21144 6.91793C1.02574 6.61983 0.623883 6.52466 0.316321 6.7038C0.00730826 6.88434 -0.0927945 7.27061 0.0943541 7.5687L1.54802 9.8919C3.685 13.1668 5.93513 14.884 8.23459 14.9945C8.31438 14.9987 8.39273 15.0001 8.46962 15.0001C9.16453 15.0001 9.78401 14.8504 10.3135 14.6349C10.7502 14.4571 10.8576 13.9085 10.5137 13.5936L10.5108 13.5922Z",
    fill: "white"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_79906_35"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "24",
    height: "15",
    fill: "currentColor"
  })))),
  'wp-travel-engine-color': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "49",
    height: "32",
    viewBox: "0 0 49 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_79906_46)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M48.7691 16.2806C49.4356 15.2745 48.4433 14.4265 48.4433 14.4265C48.4433 14.4265 47.2852 13.8324 46.6217 14.8385C45.9552 15.8447 44.2758 18.3885 44.2758 18.3885L37.4248 18.5497L36.2755 20.2873L42.0928 21.6876L39.4833 24.8643C40.2949 25.1838 40.9851 25.7719 41.767 26.166L44.2403 23.1296L47.7621 28.0022L48.9113 26.2646L46.4203 19.8305C46.4232 19.8305 48.1056 17.2868 48.7691 16.2806Z",
    fill: "#3F494B"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.3267 14.8505C26.3961 14.8505 28.0736 13.1596 28.0736 11.0737C28.0736 8.98782 26.3961 7.29688 24.3267 7.29688C22.2574 7.29688 20.5798 8.98782 20.5798 11.0737C20.5798 13.1596 22.2574 14.8505 24.3267 14.8505Z",
    fill: "url(#paint0_linear_79906_46)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M45.0755 19.2484C44.4535 18.8543 43.6301 19.0424 43.2391 19.6723C39.43 25.769 35.452 29.101 31.7348 29.304C27.0282 29.5667 23.9299 24.9479 21.2257 21.8638C19.7921 20.2277 18.4888 18.4811 17.3514 16.624C16.451 15.1581 15.4557 13.4055 15.4557 11.632C15.4528 6.69976 19.4337 2.68707 24.3268 2.68707C29.2171 2.68707 33.198 6.69976 33.198 11.632C33.198 14.5848 29.6732 19.3141 26.6461 22.7654C26.1692 23.3088 26.2225 24.1358 26.7527 24.6285C26.7616 24.6344 26.7675 24.6434 26.7764 24.6494C27.3155 25.151 28.1626 25.1032 28.6484 24.5508C31.7762 21.0069 35.8667 15.6119 35.8667 11.629C35.8638 5.2159 30.6892 0 24.3268 0C17.9645 0 12.787 5.2159 12.787 11.632C12.787 15.379 16.4095 20.3769 19.4514 23.9149L19.4426 23.906C20.2482 24.6733 20.9413 25.6018 21.7025 26.4169C23.1806 27.9933 24.6912 29.6742 26.5898 30.7311C26.5928 30.7341 26.5987 30.7341 26.6105 30.743C27.8812 31.4417 29.4837 32 31.3615 32C31.5185 32 31.6785 31.997 31.8414 31.9881C36.5361 31.7522 41.1301 28.0888 45.4931 21.1024C45.8871 20.4755 45.6975 19.6455 45.0755 19.2484Z",
    fill: "#3F494B"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.4596 28.9967C21.0716 28.6265 20.5029 28.5339 20.0112 28.7429C19.1226 29.1191 18.083 29.3699 16.9189 29.3042C13.2016 29.1012 9.22371 25.7692 5.42942 19.6935L2.47336 14.7582C2.09423 14.1223 1.27376 13.9193 0.645822 14.3014C0.014921 14.6866 -0.189455 15.5106 0.19264 16.1466L3.16054 21.1027C7.52353 28.0891 12.1176 31.7524 16.8123 31.9883C16.9752 31.9973 17.1352 32.0003 17.2921 32.0003C18.7109 32.0003 19.9757 31.6808 21.0568 31.221C21.9484 30.8418 22.1675 29.6715 21.4656 28.9997L21.4596 28.9967Z",
    fill: "url(#paint1_linear_79906_46)"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_79906_46",
    x1: "18.5361",
    y1: "6.12949",
    x2: "30.2685",
    y2: "16.6118",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00A89F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint1_linear_79906_46",
    x1: "-5.96774",
    y1: "11.3435",
    x2: "21.8683",
    y2: "42.0028",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#1FC0A1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00A89F"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_79906_46"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "49",
    height: "32",
    fill: "white"
  }))))
};
function Icon({
  icon,
  className,
  size
}) {
  const svgClass = classnames__WEBPACK_IMPORTED_MODULE_1___default()('cw-icon', className && `cw-icon__${className}`);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: svgClass,
    style: {
      '--icon-width': size?.width,
      '--icon-height': size?.height
    }
  }, icons[icon]);
}
;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);

/***/ }),

/***/ "./src/components/NoticeModal/NoticeModal.jsx":
/*!****************************************************!*\
  !*** ./src/components/NoticeModal/NoticeModal.jsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



function NoticeModal({
  closeModal
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Modal, {
    onRequestClose: closeModal
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('The selected pattern requires plugins, which unfortunately the current user does not have the permission to install and activate. Please inform the admin to provide the necessary permission or install and activate the required plugins.', 'cw-pattern-import')));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NoticeModal);

/***/ }),

/***/ "./src/components/PatternList/PatternList.jsx":
/*!****************************************************!*\
  !*** ./src/components/PatternList/PatternList.jsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var utils_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! utils/hooks */ "./src/utils/hooks/hooks.js");
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! utils */ "./src/utils/index.js");








function PatternList({
  designs,
  selectedLayout
}) {
  const [favPattern, setFavPattern] = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_4__.useLocalStorage)('cw-fav-patterns', [], true);
  const [designsList, setDesignsList] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
  const [isOpen, setOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const [requiredPlugins, setRequiredPlugins] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
  const [designToImport, setDesignToImport] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
  const [isModalOpen, setIsPreviewOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const [iframeLink, setIframeLink] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
  const [disabledButtons, setDisabledButtons] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({});
  const {
    onClose: closePatternLibraryModal
  } = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_4__.useModalContext)();
  function closeModal() {
    setOpen(false);
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (designs.length !== 0) {
      const designsList = designs.map(({
        title,
        featured_media,
        id,
        permalink,
        ...data
      }) => {
        let favIcon = 'heart_outline';
        favPattern.find(pattern => {
          if (pattern.id === id) {
            return favIcon = 'heart_fill';
          }
        });
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
          key: id,
          className: "cw-pattern-library__design-item"
        }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.FavButton, {
          icon: favIcon,
          handleClick: () => toggleFav(id)
        }), featured_media !== undefined ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
          className: "cw-pattern-library__design-item-img"
        }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
          src: `${featured_media}`,
          loading: "lazy",
          className: ""
        })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
          className: "cw-pattern-library__design-item-img no-featured-img"
        }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.Icon, {
          icon: "img"
        })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
          className: "cw-pattern-library__design-item-info"
        }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.VisuallyHidden, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, title)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
          className: "cw-pattern-library__design-preview transform-scale",
          onClick: () => handlePreviewModal(permalink),
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Preview', 'cw-pattern-import')
        }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.Icon, {
          icon: "eye"
        }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Preivew', 'cw-pattern-import')), data.meta.freevspro === '1' && cwAdmin.license_key === "valid" ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(ImportButton, {
          id: id
        }) : data.meta.freevspro === '' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(ImportButton, {
          id: id
        }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
          className: "cw-pattern-library__design-btn cw-pattern-pro cw-pattern-library-btn-is-primary transform-scale",
          href: "https://wptravelengine.com/pattern-engine/?utm_source=free_plugin&utm_medium=pattern_importer&utm_campaign=upgrade_to_pro"
        }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Buy Pro', 'cw-pattern-import'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.Icon, {
          icon: "crown"
        }))));
      });
      setDesignsList(designsList);
    }
  }, [designs, disabledButtons]);
  if (designs.length === 0) {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "cw-pattern-library__help"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('No patterns found', 'cw-pattern-import'));
  }
  const designListClass = classnames__WEBPACK_IMPORTED_MODULE_3___default()('cw-pattern-library__design-list', selectedLayout && `cw-pattern-library__design-list-col${selectedLayout}`);
  function handleInsert(selectedId) {
    designs.map(design => {
      if (design.id === selectedId) {
        // Check if required plugin is installed and activated (actiePluginData is the localized variable that has the list of installed and activated plugins)
        setDisabledButtons(prevState => ({
          ...prevState,
          [selectedId]: true
        }));
        const filteredRequiredPlugins = design.meta.required_plugins.filter(requiredPlugin => !(0,utils__WEBPACK_IMPORTED_MODULE_7__.objectExistsInArray)(requiredPlugin, cwAdmin.activePlugin));
        setRequiredPlugins(filteredRequiredPlugins);
        if (filteredRequiredPlugins.length > 0) {
          setOpen(true);
          setDesignToImport(design);
          setDisabledButtons(prevState => ({
            ...prevState,
            [selectedId]: false
          }));
          return;
        }
        (0,utils__WEBPACK_IMPORTED_MODULE_7__.insertPattern)({
          design: design,
          closePatternLibraryModal: closePatternLibraryModal
        }).then(() => {
          setDisabledButtons(prevState => ({
            ...prevState,
            [selectedId]: false
          }));
        }).catch(() => {
          setDisabledButtons(prevState => ({
            ...prevState,
            [selectedId]: false
          }));
        });
      }
    });
  }
  function toggleFav(favId) {
    setFavPattern(prevPatterns => {
      const designIndex = prevPatterns.findIndex(design => design.id === favId);
      if (designIndex !== -1) {
        // pattern is already in the favorites list, remove it
        return prevPatterns.filter((_, index) => index !== designIndex);
      }
      // pattern in not in the favorites list, add it
      return [...prevPatterns, designs.find(design => design.id === favId)];
    });
  }
  function ImportButton({
    id
  }) {
    const isDisabled = disabledButtons[id] || false;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
      className: "cw-pattern-library__design-btn cw-pattern-free transform-scale cw-pattern-library-btn-is-primary",
      onClick: () => handleInsert(id),
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import', 'cw-pattern-import'),
      showTooltip: false,
      isBusy: isDisabled
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import', 'cw-pattern-import'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.Icon, {
      icon: "down_arrow"
    }));
  }
  function handlePreviewModal(permalink) {
    setIsPreviewOpen(true);
    setIframeLink(permalink);
  }
  function closePreviewModal() {
    setIsPreviewOpen(false);
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: designListClass
  }, designsList), isOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.RequiredPluginsModal, {
    closeModal: closeModal,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Required Plugins', 'cw-pattern-import'),
    plugins: requiredPlugins,
    design: designToImport
  }), isModalOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.PreviewModal, {
    closeModal: closePreviewModal,
    patternLink: iframeLink
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternList);

/***/ }),

/***/ "./src/components/PreviewModal/PreviewModal.jsx":
/*!******************************************************!*\
  !*** ./src/components/PreviewModal/PreviewModal.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);




function PreviewModal({
  closeModal,
  patternLink
}) {
  const [iframeWidth, setIframeWidth] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('100%');
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(true);
  function handleWindowWidth(val) {
    if (val === 'desktop') {
      setIframeWidth('100%');
    } else if (val === 'tablet') {
      setIframeWidth('768px');
    } else if (val === 'mobile') {
      setIframeWidth('500px');
    }
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Modal, {
    onRequestClose: closeModal,
    className: "cw-pattern-library-preview",
    isFullScreen: true,
    shouldCloseOnClickOutside: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library-preview-header"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_2__.SegmentedControl, {
    name: "group-1",
    callback: handleWindowWidth,
    defaultIndex: 0,
    controlRef: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(),
    segments: [{
      label: 'Desktop',
      value: 'desktop',
      icon: 'desktop',
      ref: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)()
    }, {
      label: 'Tablet',
      value: 'tablet',
      icon: 'tablet',
      ref: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)()
    }, {
      label: 'Mobile',
      value: 'mobile',
      icon: 'mobile',
      ref: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)()
    }]
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library-preview-wrap",
    style: {
      '--iframe-width': iframeWidth
    }
  }, isLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Spinner, null) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    src: patternLink,
    loading: "lazy",
    allowFullScreen: true,
    allowtransparency: "true",
    style: {
      border: 0,
      position: 'absolute',
      top: 0,
      left: 0,
      width: '100%',
      height: '100%',
      transition: '0.3s'
    },
    referrerPolicy: "no-referrer-when-downgrade",
    className: "cw-pattern-library-preview-iframe",
    title: "Pattern preivew",
    onLoad: () => setIsLoading(false)
  }))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewModal);

/***/ }),

/***/ "./src/components/RequiredPluginsModal/RequiredPluginsModal.jsx":
/*!**********************************************************************!*\
  !*** ./src/components/RequiredPluginsModal/RequiredPluginsModal.jsx ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! utils */ "./src/utils/index.js");
/* harmony import */ var utils_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! utils/hooks */ "./src/utils/hooks/hooks.js");






function RequiredPluginsModal({
  closeModal,
  title,
  plugins,
  design,
  ...props
}) {
  const [buttonState, setButtonState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('install');
  const [activateUrls, setActivateUrls] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const {
    onClose: closePatternLibraryModal
  } = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_5__.useModalContext)();
  const pluginsList = plugins.map((plugin, index) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
      key: index,
      className: "cw-pattern-library-plugins-item"
    }, plugin.name);
  });

  // Memoize the pluginsToInstall array to prevent unnecessary re-renders
  const pluginsToInstall = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    if (cwAdmin.userCan.installPlugins) {
      return plugins.filter(plugin => !(0,utils__WEBPACK_IMPORTED_MODULE_4__.objectExistsInArray)(plugin, cwAdmin.inactive));
    }
    return [];
  }, [plugins]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (cwAdmin.userCan.installPlugins && pluginsToInstall.length === 0) {
      const pluginsToActivate = cwAdmin.inactive.filter(plugin => (0,utils__WEBPACK_IMPORTED_MODULE_4__.objectExistsInArray)(plugin, plugins));
      const urls = pluginsToActivate.map(plugin => plugin.url).map(url => url.replace(/&amp;/g, '&'));
      setActivateUrls(prevUrls => [...prevUrls, ...urls]);
      setButtonState('activate');
    }
  }, [pluginsToInstall, plugins]);
  function installPlugins(plugins) {
    if (!cwAdmin.userCan.installPlugins) {
      alert((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('The selected pattern requires plugins, which unfortunately the current user does not have the permission to install and activate. Please inform the admin to provide the necessary permission or install and activate the required plugins.', 'cw-pattern-import'));
      return;
    }
    if (!wp) {
      return;
    }
    setButtonState('installing');
    // Map each plugin installation to a promise
    const installPromises = plugins.map(plugin => {
      return new Promise((resolve, reject) => {
        wp.updates.installPlugin({
          slug: plugin.slug,
          success: response => {
            setActivateUrls(prevUrls => [...prevUrls, response.activateUrl]);
            resolve();
          },
          // Resolve the promise on success
          error: error => console.error(error) // Reject the promise on error
        });
      });
    });

    // Wait for all promises to resolve
    Promise.all(installPromises).then(() => {
      console.log('All plugins installed successfully');
      setButtonState('activate');
    }).catch(error => {
      console.error('Error installing plugins:', error);
    });
  }
  async function activatePlugins() {
    setButtonState('activating');
    for (const url of activateUrls) {
      try {
        const response = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: new URLSearchParams({
            _wpnonce: new URL(url).searchParams.get('_wpnonce'),
            action: 'activate',
            plugin: new URL(url).searchParams.get('plugin')
          }).toString()
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        console.log(`Plugin activated successfully: ${url}`);
      } catch (error) {
        console.error(`Error activating plugin: ${url}`, error);
      }
    }
    setButtonState('import');
  }
  function handleDesignImport(design) {
    (0,utils__WEBPACK_IMPORTED_MODULE_4__.insertPattern)({
      design: design,
      reload: true,
      closeModal: closeModal,
      closePatternLibraryModal: closePatternLibraryModal
    });
    setButtonState('importing');
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Modal, {
    onRequestClose: closeModal,
    title: title,
    className: "cw-pattern-library-plugins",
    size: "medium",
    isFullScreen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "cw-pattern-library-plugins-message"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('The following plugins need to be installed and activated in order to use this pattern.', 'cw-pattern-import')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "cw-pattern-library-plugins-list"
  }, pluginsList), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library-plugins__action"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: closeModal,
    variant: "secondary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Cancel', 'cw-pattern-import')), buttonState === 'install' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: () => installPlugins(pluginsToInstall),
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Install', 'cw-pattern-import')), buttonState === 'installing' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isBusy: true,
    disabled: true,
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Installing...', 'cw-pattern-import')), buttonState === 'activate' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: activatePlugins,
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Activate', 'cw-pattern-import')), buttonState === 'activating' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isBusy: true,
    disabled: true,
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Activating...', 'cw-pattern-import')), buttonState === 'import' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: () => handleDesignImport(design),
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import', 'cw-pattern-import')), buttonState === 'importing' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isBusy: true,
    disabled: true,
    className: "cw-pattern-library-btn-is-primary"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Importing...', 'cw-pattern-import'))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequiredPluginsModal);

/***/ }),

/***/ "./src/components/SegmentedControl/SegmentedControl.jsx":
/*!**************************************************************!*\
  !*** ./src/components/SegmentedControl/SegmentedControl.jsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);




function SegmentedControl({
  name,
  segments,
  callback,
  defaultIndex = 0,
  controlRef
}) {
  const [activeIndex, setActiveIndex] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(defaultIndex);
  const componentReady = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    componentReady.current = true;
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const activeSegmentRef = segments[activeIndex].ref;
    const {
      offsetWidth,
      offsetLeft
    } = activeSegmentRef.current;
    const {
      style
    } = controlRef.current;
    style.setProperty('--highlight-width', `${offsetWidth}px`);
    style.setProperty('--highlight-x-pos', `${offsetLeft}px`);
  }, [activeIndex, callback, segments, controlRef]);
  function onInputChange(value, index) {
    setActiveIndex(index);
    callback(value, index);
  }
  const controlsClass = classnames__WEBPACK_IMPORTED_MODULE_3___default()('controls', {
    ready: componentReady.current === true,
    idle: componentReady.current === false
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "controls-container",
    ref: controlRef
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: controlsClass
  }, segments.map((item, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: item.value,
    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('segment', {
      active: i === activeIndex,
      inactive: i !== activeIndex
    }),
    ref: item.ref
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "radio",
    value: item.value,
    id: item.label,
    name: name,
    onChange: () => onInputChange(item.value, i),
    checked: i === activeIndex
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: item.label
  }, item.icon ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: item.icon
  }) : item.label)))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SegmentedControl);

/***/ }),

/***/ "./src/components/Sidebar/Category/Category.jsx":
/*!******************************************************!*\
  !*** ./src/components/Sidebar/Category/Category.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);



function Category({
  handleCategory,
  categories,
  designCount,
  selectedCategory
}) {
  const flatCategories = categories.flatMap(Object.values);
  const uniqueCategories = Array.from(new Map(flatCategories.map(item => [item.slug, item])).values());
  const order = ['banner', 'trips', 'destination', 'activities', 'testimonials', 'logo', 'ctas', 'blog', 'about', 'team', 'services', 'map'];
  const orderedUniqueCategories = uniqueCategories.sort((a, b) => {
    const indexA = order.indexOf(a.slug);
    const indexB = order.indexOf(b.slug);
    if (indexA === -1 && indexB === -1) {
      return a.slug.localeCompare(b.slug);
    }
    if (indexA === -1) {
      return 1;
    }
    if (indexB === -1) {
      return -1;
    }
    return indexA - indexB;
  });
  const allCatBtn = classnames__WEBPACK_IMPORTED_MODULE_2___default()('cw-pattern-library__category-btn transform-scale', {
    'is-active': selectedCategory === ''
  });
  const categoryButtons = uniqueCategories.map(({
    name,
    count
  }) => {
    const categoryBtn = classnames__WEBPACK_IMPORTED_MODULE_2___default()('cw-pattern-library__category-btn transform-scale', {
      'is-active': selectedCategory === name
    });
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
      key: name
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
      className: categoryBtn,
      style: {
        '--scale-x': '0.99',
        '--scale-y': '0.99'
      },
      onClick: () => handleCategory(name)
    }, name));
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__category"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "cw-pattern-library__category-list"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: allCatBtn,
    style: {
      '--scale-x': '0.99',
      '--scale-y': '0.99'
    },
    onClick: () => handleCategory('')
  }, "All", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, designCount))), categoryButtons));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Category);

/***/ }),

/***/ "./src/components/Sidebar/Search/Search.jsx":
/*!**************************************************!*\
  !*** ./src/components/Sidebar/Search/Search.jsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



function Search({
  handleSearch,
  searchQuery
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SearchControl, {
    value: searchQuery,
    onChange: handleSearch,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search for …', 'cw-pattern-import'),
    className: "cw-pattern-library__search"
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

/***/ }),

/***/ "./src/components/TopBar/TopBar.jsx":
/*!******************************************!*\
  !*** ./src/components/TopBar/TopBar.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var utils_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! utils/hooks */ "./src/utils/hooks/hooks.js");






function TopBar({
  handleLayoutChange,
  planOptions,
  plan,
  handlePlanChange,
  selectedLayout
}) {
  const {
    sync,
    handleSync
  } = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_5__.useModalContext)();
  const col2Class = classnames__WEBPACK_IMPORTED_MODULE_4___default()('cw-layout-btn transform-scale', {
    'is-active': selectedLayout === 2
  });
  const col3Class = classnames__WEBPACK_IMPORTED_MODULE_4___default()('cw-layout-btn transform-scale', {
    'is-active': selectedLayout === 3
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, cwAdmin.freeProFilter && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    value: plan,
    options: planOptions,
    onChange: value => handlePlanChange(value),
    className: "cw-pattern-library__select",
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__btn-group"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: () => handleSync(true),
    className: "cw-sync-btn transform-scale",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Sync Library', 'cw-pattern-import')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: "sync"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "cw-divider"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: () => handleLayoutChange(3),
    className: col3Class,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('3 Column Preview', 'cw-pattern-import')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: "col3"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: () => handleLayoutChange(2),
    className: col2Class,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('2 Column Preview', 'cw-pattern-import')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: "col2"
  }))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TopBar);

/***/ }),

/***/ "./src/components/index.js":
/*!*********************************!*\
  !*** ./src/components/index.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Category: () => (/* reexport safe */ _Sidebar_Category_Category_jsx__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   FavButton: () => (/* reexport safe */ _FavButton_FavButton_jsx__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   Icon: () => (/* reexport safe */ _Icon_jsx__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   NoticeModal: () => (/* reexport safe */ _NoticeModal_NoticeModal_jsx__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   PatternList: () => (/* reexport safe */ _PatternList_PatternList_jsx__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   PreviewModal: () => (/* reexport safe */ _PreviewModal_PreviewModal_jsx__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   RequiredPluginsModal: () => (/* reexport safe */ _RequiredPluginsModal_RequiredPluginsModal_jsx__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   Search: () => (/* reexport safe */ _Sidebar_Search_Search_jsx__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SegmentedControl: () => (/* reexport safe */ _SegmentedControl_SegmentedControl_jsx__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   TopBar: () => (/* reexport safe */ _TopBar_TopBar_jsx__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _Icon_jsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon.jsx */ "./src/components/Icon.jsx");
/* harmony import */ var _Sidebar_Category_Category_jsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Sidebar/Category/Category.jsx */ "./src/components/Sidebar/Category/Category.jsx");
/* harmony import */ var _Sidebar_Search_Search_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Sidebar/Search/Search.jsx */ "./src/components/Sidebar/Search/Search.jsx");
/* harmony import */ var _TopBar_TopBar_jsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TopBar/TopBar.jsx */ "./src/components/TopBar/TopBar.jsx");
/* harmony import */ var _PatternList_PatternList_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PatternList/PatternList.jsx */ "./src/components/PatternList/PatternList.jsx");
/* harmony import */ var _FavButton_FavButton_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FavButton/FavButton.jsx */ "./src/components/FavButton/FavButton.jsx");
/* harmony import */ var _RequiredPluginsModal_RequiredPluginsModal_jsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./RequiredPluginsModal/RequiredPluginsModal.jsx */ "./src/components/RequiredPluginsModal/RequiredPluginsModal.jsx");
/* harmony import */ var _NoticeModal_NoticeModal_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./NoticeModal/NoticeModal.jsx */ "./src/components/NoticeModal/NoticeModal.jsx");
/* harmony import */ var _PreviewModal_PreviewModal_jsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./PreviewModal/PreviewModal.jsx */ "./src/components/PreviewModal/PreviewModal.jsx");
/* harmony import */ var _SegmentedControl_SegmentedControl_jsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SegmentedControl/SegmentedControl.jsx */ "./src/components/SegmentedControl/SegmentedControl.jsx");











/***/ }),

/***/ "./src/pattern-library/PatternLibrary.jsx":
/*!************************************************!*\
  !*** ./src/pattern-library/PatternLibrary.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var utils_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! utils/hooks */ "./src/utils/hooks/hooks.js");





const planOptions = [{
  label: 'All',
  value: ''
}, {
  label: 'Free',
  value: 'free'
}, {
  label: 'Pro',
  value: 'pro'
}];
function PatternLibrary({
  tab,
  designs,
  categories
}) {
  const [searchQuery, setSearchQuery] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [filters, setFilters] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    patterns: '',
    page: ''
  });
  const [plans, setPlans] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    patterns: '',
    page: ''
  });
  const [layout, setLayout] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(3);
  const debouncedSearchQuery = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_4__.useDebounce)(searchQuery, 500);
  const handleSearch = value => {
    setSearchQuery(value);
  };
  const handleLayoutChange = value => {
    setLayout(value);
  };
  const handlePlanChange = (value, filterType) => {
    setPlans(prevPlans => ({
      ...prevPlans,
      [filterType]: value
    }));
  };
  const handleFilterChange = (value, filterType) => {
    setFilters(prevFilters => ({
      ...prevFilters,
      [filterType]: value
    }));
  };
  const filteredDesigns = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    if (!designs) return [];
    let filteredDesigns = designs;
    if (debouncedSearchQuery) {
      filteredDesigns = filteredDesigns.filter(design => {
        const queryLowerCase = searchQuery.toLocaleLowerCase();
        const titleMatch = design.title.toLocaleLowerCase().indexOf(queryLowerCase) !== -1;
        const tagMatch = design.tag ? Object.values(design.tag).some(tag => tag.name.toLocaleLowerCase().indexOf(queryLowerCase) !== -1) : '';
        return titleMatch || tagMatch;
      });
    }
    const filter = filters[tab];
    if (filter) {
      filteredDesigns = filteredDesigns.filter(filteredDesign => {
        const matchCategory = Object.values(filteredDesign.cw_categories ? filteredDesign.cw_categories : []).some(category => category.name.toLocaleLowerCase() === filter.toLocaleLowerCase());
        const matchTag = filteredDesign.tag ? Object.values(filteredDesign.tag).some(tag => tag.name.toLocaleLowerCase() === filter.toLocaleLowerCase()) : '';
        return matchCategory || matchTag;
      });
    }
    const plan = plans[tab];
    if (plan) {
      filteredDesigns = filteredDesigns.filter(design => {
        const desingPlan = design.meta.freevspro === '1' ? 'pro' : 'free';
        const matchPlan = plan === desingPlan.toLocaleLowerCase();
        return matchPlan;
      });
    }
    return filteredDesigns;
  }, [designs, filters, debouncedSearchQuery, tab, plans, searchQuery]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__content"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "cw-pattern-library__sidebar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__sidebar-sticky"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Search, {
    handleSearch: handleSearch,
    searchQuery: searchQuery
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Category, {
    categories: categories,
    handleCategory: value => handleFilterChange(value, tab),
    designCount: designs.length,
    selectedCategory: filters[tab]
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__main"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__topbar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.TopBar, {
    plan: plans[tab],
    planOptions: planOptions,
    handleLayoutChange: handleLayoutChange,
    handlePlanChange: value => handlePlanChange(value, tab),
    selectedLayout: layout
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__design"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__design-wrap"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.PatternList, {
    designs: filteredDesigns,
    selectedLayout: layout
  })))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternLibrary);

/***/ }),

/***/ "./src/pattern-library/PatternModal.jsx":
/*!**********************************************!*\
  !*** ./src/pattern-library/PatternModal.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! components */ "./src/components/index.js");
/* harmony import */ var _PatternLibrary__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PatternLibrary */ "./src/pattern-library/PatternLibrary.jsx");
/* harmony import */ var utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! utils */ "./src/utils/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var utils_hooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! utils/hooks */ "./src/utils/hooks/hooks.js");








function PatternModal({
  onClose,
  fullScreen,
  className
}) {
  const [sync, setSync] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const [isError, setIsError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const [patterns, setPatterns] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
  const [favPattern, setFavPattern] = (0,utils_hooks__WEBPACK_IMPORTED_MODULE_7__.useLocalStorage)('cw-fav-patterns', [], false);

  // Fetch patterns
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    const controller = new AbortController();
    setIsLoading(true);
    if (sync) {
      setPatterns([]);
    }
    (0,utils__WEBPACK_IMPORTED_MODULE_5__.fetchDesigns)(sync, controller).then(response => {
      if (response === 'error') {
        setIsError(true);
      } else {
        setPatterns(response);
      }
    }).finally(() => {
      setSync(false);
      setIsLoading(false);
    });
    return () => controller.abort();
  }, [sync]);

  // wrap handleSync function with useCallback to avoid unnecessary re-renders
  const handleSync = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(value => {
    setSync(value);
  }, []);
  const modalContextValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => ({
    sync,
    handleSync,
    onClose
  }), [sync, handleSync, onClose]);
  function filterCategories(designs) {
    return designs.map(pattern => pattern.cw_categories ? pattern.cw_categories : []);
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Modal, {
    onRequestClose: onClose,
    isFullScreen: fullScreen,
    className: className,
    title: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
      icon: "wp-travel-engine-color",
      className: "logo"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.VisuallyHidden, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('CW Pattern Library', 'cw-pattern-import')))
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-pattern-library__wrap"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TabPanel, {
    className: "cw-pattern-library__tabs",
    activeClass: "patterns",
    tabs: [{
      name: 'patterns',
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Patterns', 'cw-pattern-import'),
      className: 'cw-tab-btn patterns transform-scale'
    }, {
      name: 'page',
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Page', 'cw-pattern-import'),
      className: 'cw-tab-btn page transform-scale'
    }, {
      name: 'saved',
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Favorites', 'cw-pattern-import'),
      className: 'cw-tab-btn saved transform-scale'
    }]
  }, tab => {
    if (isError) {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-pattern-library__center"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
        icon: "error"
      }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Something went wrong please try again', 'cw-pattern-import')));
    }
    if (isLoading || sync) {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-pattern-library__center"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Spinner, null));
    }
    let designs;
    if (tab.name === 'patterns') {
      designs = patterns.filter(pattern => pattern.meta.fullpage === '');
    } else if (tab.name === 'page') {
      designs = patterns.filter(design => design.meta.fullpage === '1');
    } else {
      designs = favPattern;
    }
    const categories = filterCategories(designs);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(utils_hooks__WEBPACK_IMPORTED_MODULE_7__.ModalContext.Provider, {
      value: modalContextValue
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_PatternLibrary__WEBPACK_IMPORTED_MODULE_4__["default"], {
      tab: tab.name,
      designs: designs,
      categories: categories
    }));
  })));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternModal);

/***/ }),

/***/ "./src/pattern-library/ToolbarWrap.jsx":
/*!*********************************************!*\
  !*** ./src/pattern-library/ToolbarWrap.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _PatternModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PatternModal */ "./src/pattern-library/PatternModal.jsx");
/* harmony import */ var components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! components */ "./src/components/index.js");






function ToolbarWrap() {
  const [isModalOpen, setIsModalOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Open CW Pattern Library', 'cw-pattern-import'),
    onClick: () => {
      setIsModalOpen(true);
    },
    className: "cw-pattern-toolbar-btn"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(components__WEBPACK_IMPORTED_MODULE_5__.Icon, {
    icon: "wp-travel-engine-white"
  }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Pattern Engine', 'cw-pattern-import')), isModalOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_PatternModal__WEBPACK_IMPORTED_MODULE_4__["default"], {
    onClose: () => setIsModalOpen(false),
    fullScreen: true,
    className: "cw-pattern-library"
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToolbarWrap);

/***/ }),

/***/ "./src/pattern-library/toolbar.js":
/*!****************************************!*\
  !*** ./src/pattern-library/toolbar.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _ToolbarWrap_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ToolbarWrap.jsx */ "./src/pattern-library/ToolbarWrap.jsx");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5__);






function PatternToolbar() {
  const toolbarWrap = document.createElement('div');
  toolbarWrap.classList.add('cw-toolbar-wrapper');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createRoot)(toolbarWrap).render((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_ToolbarWrap_jsx__WEBPACK_IMPORTED_MODULE_4__["default"], null));
  (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.subscribe)(() => {
    const toolbar = document.querySelector('.edit-post-header-toolbar');
    if (!toolbar) {
      return;
    }
    if (!toolbar.querySelector('.cw-toolbar-wrapper')) {
      toolbar.appendChild(toolbarWrap);
    }
  });
}
_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5___default()(PatternToolbar);

/***/ }),

/***/ "./src/utils/fetch.js":
/*!****************************!*\
  !*** ./src/utils/fetch.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchDesigns: () => (/* binding */ fetchDesigns)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);


let patterns = null;
async function fetchDesigns(sync, controller) {
  if (!patterns || sync) {
    try {
      const res = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
        path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(`/block-patterns/v1/patterns`, {
          sync: sync
        }),
        signal: controller?.signal
      });
      patterns = await res;
    } catch (error) {
      let message;
      if (error.name === 'AbortError') {
        message = 'Request has been aborted';
        console.log(message);
      } else {
        console.error(error);
        message = 'An error occurred while fetching designs';
      }
      console.error(`ERROR: ${message}`);
      return 'error';
    }
  }
  return patterns;
}

/***/ }),

/***/ "./src/utils/getPlugins.jsx":
/*!**********************************!*\
  !*** ./src/utils/getPlugins.jsx ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GetAllPlugins: () => (/* binding */ GetAllPlugins),
/* harmony export */   getPlugins: () => (/* binding */ getPlugins)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);

function GetAllPlugins() {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select('core').getPlugins(), []);
}
function getPlugins(status) {
  const plugins = GetAllPlugins()?.filter(plugin => plugin.status === status).map(plugin => {
    return {
      name: plugin.name,
      slug: plugin.plugin.split('/')[0]
    };
  });
  return plugins ? plugins : [];
}

/***/ }),

/***/ "./src/utils/hooks/hooks.js":
/*!**********************************!*\
  !*** ./src/utils/hooks/hooks.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalContext: () => (/* reexport safe */ _useModalContext_jsx__WEBPACK_IMPORTED_MODULE_2__.ModalContext),
/* harmony export */   useDebounce: () => (/* reexport safe */ _usedebounce_jsx__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   useLocalStorage: () => (/* reexport safe */ _useLocalStorage_jsx__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   useModalContext: () => (/* reexport safe */ _useModalContext_jsx__WEBPACK_IMPORTED_MODULE_2__.useModalContext)
/* harmony export */ });
/* harmony import */ var _useLocalStorage_jsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useLocalStorage.jsx */ "./src/utils/hooks/useLocalStorage.jsx");
/* harmony import */ var _usedebounce_jsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./usedebounce.jsx */ "./src/utils/hooks/usedebounce.jsx");
/* harmony import */ var _useModalContext_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useModalContext.jsx */ "./src/utils/hooks/useModalContext.jsx");




/***/ }),

/***/ "./src/utils/hooks/useLocalStorage.jsx":
/*!*********************************************!*\
  !*** ./src/utils/hooks/useLocalStorage.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);

function useLocalStorage(key, defaultValue, dispatch) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
    let currentValue;
    try {
      currentValue = JSON.parse(localStorage.getItem(key) || String(defaultValue));
    } catch (error) {
      currentValue = defaultValue;
    }
    return currentValue;
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleStorageChange = e => {
      if (e.storageArea === localStorage && e.key === key) {
        try {
          const newValue = JSON.parse(e.newValue);
          setValue(newValue);
        } catch (error) {
          setValue(defaultValue);
        }
      }
    };
    window.addEventListener('storage', handleStorageChange);
    return () => {
      window.removeEventListener('storage', handleStorageChange);
    };
  }, [key, defaultValue]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // dispatch a storage event from the same tab if dispatch is true
    if (dispatch) {
      const currentValue = localStorage.getItem(key);
      if (currentValue !== JSON.stringify(value)) {
        localStorage.setItem(key, JSON.stringify(value));

        // manually dispatch a storage event to trigger the storage event listener
        const storageEvent = new StorageEvent('storage', {
          key,
          newValue: JSON.stringify(value),
          storageArea: localStorage
        });
        window.dispatchEvent(storageEvent);
      }
    } else {
      localStorage.setItem(key, JSON.stringify(value));
    }
  }, [value, key]);
  return [value, setValue, dispatch];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useLocalStorage);

/***/ }),

/***/ "./src/utils/hooks/useModalContext.jsx":
/*!*********************************************!*\
  !*** ./src/utils/hooks/useModalContext.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalContext: () => (/* binding */ ModalContext),
/* harmony export */   useModalContext: () => (/* binding */ useModalContext)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);

const ModalContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(undefined);
function useModalContext() {
  const modal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useContext)(ModalContext);
  if (modal === undefined) {
    throw new Error('useModalContext must be used with a ModalContext');
  }
  return modal;
}

/***/ }),

/***/ "./src/utils/hooks/usedebounce.jsx":
/*!*****************************************!*\
  !*** ./src/utils/hooks/usedebounce.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);

function useDebounce(value, delay) {
  const [debouncedValue, setDebouncedValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handler = setTimeout(() => {
      setDebouncedValue(value);
    }, delay);
    return () => {
      clearTimeout(handler);
    };
  }, [value, delay]);
  return debouncedValue;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDebounce);

/***/ }),

/***/ "./src/utils/index.js":
/*!****************************!*\
  !*** ./src/utils/index.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchDesigns: () => (/* reexport safe */ _fetch__WEBPACK_IMPORTED_MODULE_0__.fetchDesigns),
/* harmony export */   getAllPlugins: () => (/* reexport safe */ _getPlugins__WEBPACK_IMPORTED_MODULE_2__.GetAllPlugins),
/* harmony export */   getPlugins: () => (/* reexport safe */ _getPlugins__WEBPACK_IMPORTED_MODULE_2__.getPlugins),
/* harmony export */   insertPattern: () => (/* reexport safe */ _insertPattern__WEBPACK_IMPORTED_MODULE_1__.insertPattern),
/* harmony export */   objectExistsInArray: () => (/* reexport safe */ _objectExistsInArray__WEBPACK_IMPORTED_MODULE_3__.objectExistsInArray)
/* harmony export */ });
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./fetch */ "./src/utils/fetch.js");
/* harmony import */ var _insertPattern__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./insertPattern */ "./src/utils/insertPattern.js");
/* harmony import */ var _getPlugins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getPlugins */ "./src/utils/getPlugins.jsx");
/* harmony import */ var _objectExistsInArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./objectExistsInArray */ "./src/utils/objectExistsInArray.js");






/***/ }),

/***/ "./src/utils/insertPattern.js":
/*!************************************!*\
  !*** ./src/utils/insertPattern.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   insertPattern: () => (/* binding */ insertPattern)
/* harmony export */ });
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);


async function insertPattern({
  design,
  reload = false,
  closeModal = undefined,
  closePatternLibraryModal
}) {
  const controller = typeof AbortController === 'undefined' ? undefined : new AbortController();
  try {
    const url = `https://fsedemo.com/pattern-engine/wp-json/block-pattern/v1/patterns/${design.id}`;
    const res = await fetch(url, {
      method: 'GET',
      signal: controller.signal,
      headers: {
        'Content-Type': 'application/json'
      }
    });
    if (!res.ok) {
      throw new Error('Network response was not ok');
    }
    const pattern = await res.json();
    try {
      const parsedBlocks = JSON.parse(pattern.content);
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.dispatch)('core/block-editor').insertBlocks((0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.parse)(parsedBlocks));
      if (cwAdmin.userCan.editPost && reload) {
        try {
          await (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.dispatch)('core/editor').savePost();
          if (typeof closeModal === 'function') {
            closeModal();
          }
          if (typeof closePatternLibraryModal === 'function') {
            closePatternLibraryModal();
          }
          window.location.reload();
        } catch (error) {
          console.error('Error saving post:', error);
        }
      }
      if (typeof closeModal === 'function') {
        closeModal();
      }
      if (typeof closePatternLibraryModal === 'function') {
        closePatternLibraryModal();
      }
    } catch (error) {
      console.error('Error parsing or inserting blocks:', error);
    }
  } catch (error) {
    if (error.name == 'AbortError') {
      console.error('Content fetch aborted for URL:', error.message);
    } else {
      console.error('Error fetching content from URL:', error.message);
    }
  } finally {
    controller?.abort();
  }
}

/***/ }),

/***/ "./src/utils/objectExistsInArray.js":
/*!******************************************!*\
  !*** ./src/utils/objectExistsInArray.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objectExistsInArray: () => (/* binding */ objectExistsInArray)
/* harmony export */ });
function objectExistsInArray(obj, array) {
  return array.some(el => el.slug === obj.slug);
}

/***/ }),

/***/ "./src/style/index.scss":
/*!******************************!*\
  !*** ./src/style/index.scss ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ "@wordpress/api-fetch":
/*!**********************************!*\
  !*** external ["wp","apiFetch"] ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["apiFetch"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/dom-ready":
/*!**********************************!*\
  !*** external ["wp","domReady"] ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["domReady"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "@wordpress/url":
/*!*****************************!*\
  !*** external ["wp","url"] ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["url"];

/***/ }),

/***/ "../../../node_modules/classnames/index.js":
/*!*************************************************!*\
  !*** ../../../node_modules/classnames/index.js ***!
  \*************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = '';

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (arg) {
				classes = appendClass(classes, parseValue(arg));
			}
		}

		return classes;
	}

	function parseValue (arg) {
		if (typeof arg === 'string' || typeof arg === 'number') {
			return arg;
		}

		if (typeof arg !== 'object') {
			return '';
		}

		if (Array.isArray(arg)) {
			return classNames.apply(null, arg);
		}

		if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
			return arg.toString();
		}

		var classes = '';

		for (var key in arg) {
			if (hasOwn.call(arg, key) && arg[key]) {
				classes = appendClass(classes, key);
			}
		}

		return classes;
	}

	function appendClass (value, newClass) {
		if (!newClass) {
			return value;
		}
	
		if (value) {
			return value + ' ' + newClass;
		}
	
		return value + newClass;
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _pattern_library_toolbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pattern-library/toolbar */ "./src/pattern-library/toolbar.js");
/* harmony import */ var _style_index_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style/index.scss */ "./src/style/index.scss");


})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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