

<?php $__env->startSection('content'); ?>
<div class="container mt-5 mb-5" style="max-width: 600px;">
    <div class="card shadow-sm rounded">
        <div class="card-header bg-primary text-white text-center">
            <h4>Tambah Keberangkatan</h4>
        </div>
        <div class="card-body">
            <form id="formKeberangkatan">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label for="no_ktp" class="form-label">No. KTP</label>
                    <input type="number" class="form-control" id="no_ktp" name="no_ktp" required 
                        minlength="16" maxlength="16" 
                        oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                    <div class="invalid-feedback">Harap isi No. KTP (16 digit angka)</div>
                </div>
                <div class="form-group mb-3">
                    <label for="kode_afiliasi" class="form-label">Kode Afiliasi</label>
                    <input id="kode_afiliasi" type="text" class="form-control" name="kode_afiliasi" required maxlength="8" >
                </div>
                <div class="mb-3">
                    <label for="tanggal_keberangkatan" class="form-label">Tanggal keberangakatan</label>
                    <input type="date" class="form-control" id="tanggal_keberangkatan" name="tanggal_keberangkatan" required>
                    <div class="invalid-feedback">Tanggal keberangakatan wajib diisi</div>
                </div>
                <div class="form-group mb-3">
                    <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
                    <select
                        id="status_pembayaran"
                        class="form-select"
                        name="status_pembayaran"
                        required
                    >
                        <option value="">-- Pilih Status --</option>
                        <option value="Belum Lunas">Belum Lunas</option>
                        <option value="Lunas">Lunas</option>
                        <option value="Pending">Pending</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="tanggal_pembayaran" class="form-label">Tanggal pembayaran</label>
                    <input type="date" class="form-control" id="tanggal_pembayaran" name="tanggal_pembayaran" required>
                    <div class="invalid-feedback">Tanggal pembayaran wajib diisi</div>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">Sumbit</button>
                    <a href="<?php echo e(route('keberangkatan.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>

            <div id="notif" class="mt-3"></div>
        </div>
    </div>
</div>

<script>
document.getElementById('formKeberangkatan').addEventListener('submit', async function(e) {
    e.preventDefault();
    const form = e.target;
    const notif = document.getElementById('notif');
    
    // Reset notifikasi dan validasi
    notif.innerHTML = '';
    document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));

    // Validasi client-side
    let isValid = true;
    const requiredFields = ['no_ktp', 'kode_afiliasi', 'tanggal_keberangkatan', 'status_pembayaran', 'tanggal_pembayaran'];
    
    requiredFields.forEach(field => {
        const input = document.getElementById(field);
        if (!input.value.trim()) {
            input.classList.add('is-invalid');
            isValid = false;
        }
    });

    // Validasi format KTP
    const noKtp = document.getElementById('no_ktp');
    if (noKtp.value && !/^\d{16}$/.test(noKtp.value)) {
        noKtp.classList.add('is-invalid');
        isValid = false;
    }

    if (!isValid) {
        notif.innerHTML = '<div class="alert alert-danger">Terdapat kesalahan dalam form. Silakan periksa kembali.</div>';
        return;
    }

    try {
        // Kirim data jika validasi lolos
        const formData = new FormData(form);
        const response = await fetch("<?php echo e(route('keberangkatan.store')); ?>", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(Object.fromEntries(formData))
        });

        const data = await response.json();
        if (data.status) {
            swal("Success!", "Create berhasil,", "success");
        } else {
            swal("Warning!", data.message, "error");
        }
    } catch (error) {
        console.error('Error:', error);
        notif.innerHTML = '<div class="alert alert-danger">Terjadi kesalahan saat mengirim data</div>';
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/keberangkatan/create.blade.php ENDPATH**/ ?>