

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">

            
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            
            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <div class="d-flex gap-2 flex-wrap">
                    <a href="<?php echo e(route('keberangkatan.create')); ?>" class="btn btn-primary">Add New</a>
                    <a href="#" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exportModal">Export</a>
                    <a href="#" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#filterModal">Filter</a>
                </div>
                <form action="<?php echo e(route('keberangkatan.search')); ?>" method="POST" class="d-flex gap-2">
                    <?php echo csrf_field(); ?>
                    <input type="text" name="search" class="form-control" placeholder="Search..." value="<?php echo e(request('search')); ?>">
                    <button type="submit" class="btn btn-outline-primary">Go</button>
                </form>
            </div>

            
            <div class="card">
                <div class="card-header">Transaction</div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Type Umroh</th>
                                    <th>No KTP</th>
                                    <th>Kode Keberangkatan</th>
                                    <th>Tanggal Keberangkatan</th>
                                    <th>Status Pembayaran</th>
                                    <th>Action Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration + ($data->currentPage() - 1) * $data->perPage()); ?></td>
                                        <td>
                                            <?php if($item->jenis_umroh == 1): ?>
                                                Reguler
                                            <?php elseif($item->jenis_umroh == 2): ?>
                                                Plus
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->no_ktp); ?></td>
                                        <td><?php echo e($item->kode_keberangkatan); ?></td>
                                        <td><?php echo e(date('d F Y', strtotime($item->tanggal_keberangkatan))); ?></td>
                                        <td><?php echo e($item->status_pembayaran); ?></td>
                                        <td>
                                            <?php if($item->status_pembayaran === 'Lunas'): ?>
                                                <a href="#" class="btn btn-warning btn-sm" onclick="approveKeberangkatan(<?php echo e($item->id); ?>)">
                                                    Un Approve
                                                </a>
                                            <?php elseif($item->status_pembayaran === 'Tabungan' || $item->status_pembayaran === 'Belum Lunas'): ?>
                                                <a href="#" class="btn btn-success btn-sm" onclick="approveKeberangkatan(<?php echo e($item->id); ?>)">
                                                    Approve
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <a href="<?php echo e(route('keberangkatan.edit', $item->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="<?php echo e(route('keberangkatan.show', $item->no_ktp)); ?>" class="btn btn-primary btn-sm">Lihat</a>
                                            <form action="<?php echo e(route('keberangkatan.destroy', $item->id)); ?>" method="POST" id="delete-form-<?php echo e($item->id); ?>" style="display: none;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                            <button type="button" class="btn btn-danger btn-sm" onclick="confirmDelete(<?php echo e($item->id); ?>)">Delete</button>
                                        </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            
            <?php if($data->lastPage() > 1): ?>
                <div class="mt-3 d-flex">
                    <ul class="pagination flex-wrap">
                        <li class="page-item <?php echo e(($data->currentPage() == 1) ? ' disabled' : ''); ?>">
                            <a class="page-link" href="<?php echo e($data->url(1)); ?>">Previous</a>
                        </li>
                        <?php for($i = 1; $i <= $data->lastPage(); $i++): ?>
                            <li class="page-item <?php echo e(($data->currentPage() == $i) ? ' active' : ''); ?>">
                                <a class="page-link" href="<?php echo e($data->url($i)); ?>"><?php echo e($i); ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?php echo e(($data->currentPage() == $data->lastPage()) ? ' disabled' : ''); ?>">
                            <a class="page-link" href="<?php echo e($data->url($data->currentPage()+1)); ?>">Next</a>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>

<!-- Modal Filter -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="<?php echo e(route('keberangkatan.index')); ?>" method="GET" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filterModalLabel">Filter Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="tanggal_keberangkatan" class="form-label">Tanggal Keberangkatan</label>
          <input type="date" name="tanggal_keberangkatan" id="tanggal_keberangkatan" class="form-control" value="<?php echo e(request('tanggal_keberangkatan')); ?>">
        </div>
        <div class="mb-3">
            <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
            <select class="form-select" id="status_pembayaran" name="status_pembayaran">
                <option value="">-- Pilih Status --</option>
                <option value="Belum Lunas">Belum Lunas</option>
                <option value="Lunas">Lunas</option>
                <option value="Pending">Pending</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Terapkan Filter</button>
      </div>
    </form>
  </div>
</div>


<!-- Modal Export -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="<?php echo e(route('keberangkatan.export')); ?>" method="POST" class="modal-content">
    <?php echo csrf_field(); ?>
      <div class="modal-header">
        <h5 class="modal-title" id="exportModalLabel">Export Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="tanggal_keberangkatan" class="form-label">Tanggal Keberangkatan</label>
          <input type="date" name="tanggal_keberangkatan" id="tanggal_keberangkatan" class="form-control" value="<?php echo e(request('tanggal_keberangkatan')); ?>">
        </div>
        <div class="mb-3">
            <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
            <select class="form-select" id="status_pembayaran" name="status_pembayaran">
                <option value="">-- Pilih Status --</option>
                <option value="Belum Lunas">Belum Lunas</option>
                <option value="Lunas">Lunas</option>
                <option value="Pending">Pending</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Export</button>
      </div>
    </form>
  </div>
</div>


<script>
    async function approveKeberangkatan(id) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const confirmResult = await swal({
            title: "Ubah Status Pembayaran",
            text: "Yakin ingin mengubah status pembayaran?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        });

        if (!confirmResult) return;

        try {
            const response = await fetch(`/keberangkatan/${id}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ id: id })
            });

            const data = await response.json();

            if (data.status) {
                swal("Berhasil!", 'Approve berhasil dilakukan', "success");
                location.reload();
            } else {
                swal("Gagal!", "Status gagal diperbarui.", "error");
            }
        } catch (error) {
            console.error('Error:', error);
            swal("Error!", "Terjadi kesalahan saat memproses permintaan.", "error");
        }
    }

    function confirmDelete(id) {
        // Menampilkan konfirmasi sebelum menghapus data
        swal({
            title: "Apakah Anda yakin?",
            text: "Data keberangkatan ini akan dihapus!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        .then((willDelete) => {
            if (willDelete) {
                // Jika pengguna mengonfirmasi, kirimkan form
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/keberangkatan/index.blade.php ENDPATH**/ ?>