<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Formulir Pendaftaran Umroh</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      font-size: 14px;
      margin: 40px;
      color: #000;
    }

    .header {
      display: flex;
      align-items: center;
      border-bottom: 3px solid #000;
      padding-bottom: 10px;
      margin-bottom: 30px;
    }

    .header img {
      width: 80px;
      height: 80px;
      margin-right: 20px;
    }

    .header h2 {
      font-size: 24px;
      text-transform: uppercase;
      margin: 0;
      flex: 1;
    }

    .form-group {
      display: flex;
      margin-bottom: 10px;
    }

    .label {
      width: 200px;
      font-weight: bold;
    }

    .value {
      flex: 1;
      border-bottom: 1px solid #999;
      padding-left: 5px;
      min-height: 18px;
    }

    .container {
      max-width: 800px;
      margin: auto;
    }

    .form-title {
      text-align: right;
      margin-top: -20px;
      margin-bottom: 20px;
      font-weight: bold;
    }

    .form-footer {
      margin-top: 50px;
      text-align: center;
      font-style: italic;
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <div class="header">
      <img src="https://elqoshwa.com/wp-content/uploads/2025/04/logo-elqoshwa-prima-wisata-1024x1024.jpg" alt="Logo">
      <h2>Formulir Pendaftaran Umroh</h2>
    </div>

    <!-- Optional Form Number -->
    <div class="form-title">No. Pendaftaran: <?php echo e($data->kode_keberangkatan); ?></div>

    <!-- Form Fields -->
     
    <div class="form-group">
      <div class="label">No KTP</div>
      <div class="value"><?php echo e($data->no_ktp); ?></div>
    </div>

    <div class="form-group">
      <div class="label">No. Passport</div>
      <div class="value"><?php echo e($data->no_passport); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Nama</div>
      <div class="value"><?php echo e($data->title); ?> <?php echo e($data->nama); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Tempat / Tanggal Lahir</div>
      <div class="value"><?php echo e($data->tempat_lahir); ?> / <?php echo e($data->tanggal_lahir); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Alamat</div>
      <div class="value"><?php echo e($data->alamat); ?></div>
    </div>

    <div class="form-group">
      <div class="label">RT / RW</div>
      <div class="value"><?php echo e($data->rt); ?> / <?php echo e($data->rw); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Kelurahan / Kecamatan</div>
      <div class="value"><?php echo e($data->kelurahan); ?> / <?php echo e($data->kecamatan); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Kota / Provinsi</div>
      <div class="value"><?php echo e($data->kota); ?> / <?php echo e($data->provinsi); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Tanggal ISS / Expired</div>
      <div class="value"><?php echo e($data->tanggal_iss); ?> / <?php echo e($data->tanggal_expired); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Tempat ISS</div>
      <div class="value"><?php echo e($data->tempat_iss); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Status Perkawinan</div>
      <div class="value"><?php echo e($data->status_perkawinan); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Pekerjaan</div>
      <div class="value"><?php echo e($data->pekerjaan); ?></div>
    </div>

    <div class="form-group">
      <div class="label">Nama Ayah</div>
      <div class="value"><?php echo e($data->nama_ayah); ?></div>
    </div>

    <!-- Footer -->
    <div class="form-footer">
      Formulir ini harus dilengkapi dan dikembalikan sebelum keberangkatan umroh.<br>
      <br><br><br>
      <div style="display:flex; justify-content: space-between; margin-top: 50px;">
        <div>TTD Jamaah<br><br><br><br>___________________</div>
        <div>TTD Petugas<br><br><br><br>___________________</div>
      </div>
    </div>
  </div>
</body>
</html>
<?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/pdf/jamaah_pdf.blade.php ENDPATH**/ ?>