

<?php $__env->startSection('content'); ?>
<div class="container mt-5 mb-5" style="max-width: 600px;">
    <div class="card shadow-sm rounded">
        <div class="card-header bg-primary text-white text-center">
            <h4>Edit Keberangkatan</h4>
        </div>

        <div class="card-body">
            <form id="editKeberangkatanForm">

                <div class="form-group mb-3">
                    <label for="no_ktp" class="form-label">No KTP</label>
                    <input type="text" class="form-control" id="no_ktp" name="no_ktp" value="<?php echo e(old('no_ktp', $keberangkatan->no_ktp)); ?>" disabled>
                </div>

                <div class="form-group mb-3">
                    <label for="kode_keberangkatan" class="form-label">Kode Keberangkatan</label>
                    <input type="text" class="form-control" id="kode_keberangkatan" name="kode_keberangkatan" value="<?php echo e(old('kode_keberangkatan', $keberangkatan->kode_keberangkatan)); ?>" disabled>
                </div>

                <div class="form-group mb-3">
                    <label for="tanggal_keberangkatan" class="form-label">Tanggal Keberangkatan</label>
                    <input type="date" class="form-control" id="tanggal_keberangkatan" name="tanggal_keberangkatan" value="<?php echo e(old('tanggal_keberangkatan', $keberangkatan->tanggal_keberangkatan)); ?>" required>
                </div>

                <div class="form-group mb-3">
                    <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
                    <select class="form-select" id="status_pembayaran" name="status_pembayaran" required>
                        <option value="">-- Pilih Status --</option>
                        <option value="Belum Lunas" <?php echo e(old('status_pembayaran', $keberangkatan->status_pembayaran) == 'Belum Lunas' ? 'selected' : ''); ?>>Belum Lunas</option>
                        <option value="Lunas" <?php echo e(old('status_pembayaran', $keberangkatan->status_pembayaran) == 'Lunas' ? 'selected' : ''); ?>>Lunas</option>
                        <option value="Pending" <?php echo e(old('status_pembayaran', $keberangkatan->status_pembayaran) == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                    </select>
                </div>

                <div class="form-group mb-4">
                    <label for="tanggal_pembayaran" class="form-label">Tanggal Pembayaran</label>
                    <input type="date" class="form-control" id="tanggal_pembayaran" name="tanggal_pembayaran" value="<?php echo e(old('tanggal_pembayaran', $keberangkatan->tanggal_pembayaran)); ?>">
                </div>

                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="<?php echo e(route('keberangkatan.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
            <!-- Alert message -->
            <div id="alertMessage" class="mt-3" style="display: none;">
                <div class="alert alert-success" role="alert">
                    Keberangkatan berhasil diupdate!
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('editKeberangkatanForm').addEventListener('submit', function(event) {
    event.preventDefault();

    // Ambil data form
    let formData = new FormData(this);

    // Ambil id keberangkatan dari URL atau data blade
    const keberangkatanId = "<?php echo e($keberangkatan->id); ?>";

    // Menambahkan _method PUT ke FormData agar Laravel mengenali permintaan PUT
    formData.append('_method', 'PUT');

    // Ambil CSRF token
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    // Kirim request ke server menggunakan fetch
    fetch(`/keberangkatan/${keberangkatanId}`, {
        method: 'POST', // Menggunakan POST karena kita mengirim PUT dengan _method
        headers: {
            'X-CSRF-TOKEN': csrfToken, // Menambahkan CSRF Token
        },
        body: formData,
    })
    .then(response => response.json())
    .then(data => {
        if (data.status) {
            swal("Success!", "Update berhasil,", "success");
        } else {
            swal("Failed!", "UPdate gagal, silakan download bukti PDF", "danger");
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan pada server.');
    });
});
</script>

<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/keberangkatan/edit.blade.php ENDPATH**/ ?>