<?php $__env->startSection('content'); ?>

<!-- header -->
<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
    <main class="flex-grow-1">
        <div class="container my-4">
            <div class="container">
                <div class="card shadow-lg">
                <div class="card-header bg-white text-secondary text-center">
                    <h4>📝 Formulir Pendaftaran</h4>
                </div>
                <div class="card-body">

                    <!-- Progress Bar & Step Info -->
                    <div class="mb-4">
                        <div class="progress mb-2" style="height: 30px;">
                            <div id="progress-bar" class="progress-bar bg-success" style="width: 0%;">0 %</div>
                        </div>
                        <h5 id="step-title" class="text-center text-secondary">Langkah 1 dari 6: Keberangkatan</h5>
                    </div>

                    <!-- Form -->
                    <form id="multiStepForm">

                    <!-- Step 1 -->
                    <div class="step active">
                        <div class="mb-3">
                            <label class="form-label">ID Afiliasi 
                                <i class="fas fa-info-circle info-icon" 
                                data-bs-toggle="popover" 
                                data-bs-placement="right"
                                data-bs-content="Isi jika Anda memiliki kode referal/referensi dari agen/marketing kami (opsional)"></i>
                            </label>
                            <input type="text" class="form-control" name="id_afiliasi" maxlength="20">
                            <small class="text-muted">(Opsional)</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tanggal Keberangkatan</label>
                            <input type="date" class="form-control" name="tanggal_keberangkatan" required>
                            <div class="invalid-feedback">Harap pilih tanggal keberangkatan</div>
                        </div>
                        <div class="mb-3">
                          <label class="form-label">Jenis Umroh</label>
                          <select class="form-select" name="jenis_umroh" required>
                              <option value="">Pilih...</option>
                            <?php $__currentLoopData = $jenis_umroh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e($item->id); ?>"><?php echo e($item->nama); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                          <div class="invalid-feedback">Harap pilih Jenis Umroh</div>
                        </div>
                    </div>

                    <!-- Step 2 -->
                    <div class="step">
                        <div class="mb-3">
                        <label class="form-label">Mr/Mrs</label>
                        <select class="form-select" name="title" required>
                            <option value="">Pilih...</option>
                            <option value="Mr">Mr</option>
                            <option value="Mrs">Mrs</option>
                        </select>
                        <div class="invalid-feedback">Harap pilih title</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Nama</label>
                        <input type="text" class="form-control" name="nama" required maxlength="100">
                        <div class="invalid-feedback">Harap isi nama lengkap (maks. 100 karakter)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Tempat Lahir</label>
                        <input type="text" class="form-control" name="tempat_lahir" required maxlength="50">
                        <div class="invalid-feedback">Harap isi tempat lahir (maks. 50 karakter)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Tanggal Lahir</label>
                        <input type="date" class="form-control" name="tanggal_lahir" required>
                        <div class="invalid-feedback">Harap pilih tanggal lahir</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">No. KTP</label>
                        <input type="number" class="form-control" name="no_ktp" required minlength="16" maxlength="16" 
                               oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                        <div class="invalid-feedback">Harap isi No. KTP (16 digit angka)</div>
                        </div>
                    </div>

                    <!-- Step 3 -->
                    <div class="step">
                        <div class="mb-3">
                        <label class="form-label">Alamat</label>
                        <input type="text" class="form-control" name="alamat" required maxlength="200">
                        <div class="invalid-feedback">Harap isi alamat lengkap (maks. 200 karakter)</div>
                        </div>
                        <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">RT</label>
                            <input type="number" class="form-control" name="rt" required maxlength="3"
                                   oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <div class="invalid-feedback">Harap isi RT (maks. 3 digit)</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">RW</label>
                            <input type="number" class="form-control" name="rw" required maxlength="3"
                                   oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <div class="invalid-feedback">Harap isi RW (maks. 3 digit)</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Kelurahan</label>
                            <input type="text" class="form-control" name="kelurahan" required maxlength="50">
                            <div class="invalid-feedback">Harap isi kelurahan (maks. 50 karakter)</div>
                        </div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Kecamatan</label>
                        <input type="text" class="form-control" name="kecamatan" required maxlength="50">
                        <div class="invalid-feedback">Harap isi kecamatan (maks. 50 karakter)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Kota/Kabupaten</label>
                        <input type="text" class="form-control" name="kota" required maxlength="50">
                        <div class="invalid-feedback">Harap isi kota/kabupaten (maks. 50 karakter)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Provinsi</label>
                        <input type="text" class="form-control" name="provinsi" required maxlength="50">
                        <div class="invalid-feedback">Harap isi provinsi (maks. 50 karakter)</div>
                        </div>
                    </div>
                    

                    <!-- Step 4 -->
                    <div class="step">
                        <div class="mb-3">
                        <label class="form-label">No Passport</label>
                        <input type="text" class="form-control" name="no_passport" required maxlength="20"
                            pattern="[A-Za-z0-9]+" 
                            title="Hanya huruf dan angka"
                            oninput="if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                        <div class="invalid-feedback">Harap isi nomor passport (maks. 20 karakter, hanya huruf dan angka)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Tanggal Issued</label>
                        <input type="date" class="form-control" name="tanggal_iss" required>
                        <div class="invalid-feedback">Harap pilih tanggal issued</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Tanggal Expired</label>
                        <input type="date" class="form-control" name="tanggal_expired" required>
                        <div class="invalid-feedback">Harap pilih tanggal expired</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Tempat Issued</label>
                        <input type="text" class="form-control" name="tempat_iss" required maxlength="50">
                        <div class="invalid-feedback">Harap isi tempat issued (maks. 50 karakter)</div>
                        </div>
                    </div>

                    <!-- Step 5 -->
                    <div class="step">
                        <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status_perkawinan" required>
                            <option value="">Pilih Status...</option>
                            <option value="kawin">Kawin</option>
                            <option value="belum kawin">Belum Kawin</option>
                            <option value="cerai hidup">Cerai Hidup</option>
                            <option value="cerai mati">Cerai Mati</option>
                        </select>
                        <div class="invalid-feedback">Harap pilih status</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Pekerjaan</label>
                        <input type="text" class="form-control" name="pekerjaan" required maxlength="50">
                        <div class="invalid-feedback">Harap isi pekerjaan (maks. 50 karakter)</div>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Nama Ayah</label>
                        <input type="text" class="form-control" name="nama_ayah" required maxlength="100">
                        <div class="invalid-feedback">Harap isi nama ayah (maks. 100 karakter)</div>
                        </div>
                    </div>

                    <!-- Step 6 -->
                    <div class="step">
                        <div class="mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title">Syarat & Ketentuan</h5>
                                    <p class="card-text">
                                    Dengan mendaftar, saya menyatakan bahwa semua data yang saya isi adalah benar dan dapat dipertanggungjawabkan.
                                    Saya telah membaca dan menyetujui semua syarat dan ketentuan dari Elqoshwa Tour & Travel.
                                    </p>
                                    <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="setujuCheckbox" required>
                                    <label class="form-check-label" for="setujuCheckbox">
                                        Saya setuju dengan syarat dan ketentuan yang berlaku
                                    </label>
                                    <div class="invalid-feedback">Anda harus menyetujui syarat dan ketentuan</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Navigation Buttons -->
                    <div class="d-flex justify-content-between pt-4">
                    <button type="button" class="btn btn-secondary px-3 px-md-4" onclick="prevStep()">
                        <span class="d-none d-md-inline">Sebelumnya</span>
                        <span class="d-inline d-md-none">←</span>
                    </button>
                    <button type="button" class="btn btn-primary px-3 px-md-4" onclick="validateAndNextStep()">
                        <span class="d-none d-md-inline">Selanjutnya</span>
                        <span class="d-inline d-md-none">→</span>
                    </button>
                    <button type="submit" class="btn btn-success px-3 px-md-4 d-none">
                        <span class="d-none d-md-inline">Kirim Form</span>
                        <span class="d-inline d-md-none">✓</span>
                    </button>
                    </div>
                    </form>

                </div>
                </div>
            </div>
        </div>
    </main>

<!-- footer -->
<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <script>
    const steps = document.querySelectorAll('.step');
    const nextBtn = document.querySelector('button.btn-primary');
    const prevBtn = document.querySelector('button.btn-secondary');
    const submitBtn = document.querySelector('button[type="submit"]');
    const stepTitle = document.getElementById('step-title');
    const progressBar = document.getElementById('progress-bar');
    const checkbox = document.getElementById('setujuCheckbox');
    let currentStep = 0;

    const stepNames = [
      "Keberangkatan",
      "Identitas Pribadi",
      "Alamat",
      "Informasi Paspor",
      "Afiliasi",
      "Syarat dan Ketentuan"
    ];

    function updateProgressBar(percent) {
      progressBar.style.width = percent + '%';
      progressBar.textContent = percent + '%';
    }

    function showStep(step) {
        steps.forEach((el, i) => el.classList.toggle('active', i === step));
        prevBtn.style.display = step === 0 ? 'none' : 'inline-block';
        nextBtn.style.display = step === steps.length - 1 ? 'none' : 'inline-block';

        if (step === steps.length - 1) {
            submitBtn.disabled = true;
        }

        submitBtn.classList.toggle('d-none', step !== steps.length - 1);
        stepTitle.textContent = `Langkah ${step + 1} dari ${steps.length}: ${stepNames[step]}`;

        const progressPercent = Math.round(((step + 0) / steps.length) * 100);
        updateProgressBar(progressPercent);
    }

    // Fungsi validasi form yang diperbarui
    function validateCurrentStep() {
      const currentStepElement = steps[currentStep];
      const inputs = currentStepElement.querySelectorAll('input[required], select[required], textarea[required]');
      let isValid = true;
      
      inputs.forEach(input => {
        // Reset validasi
        input.classList.remove('is-invalid');
        
        // Validasi input
        if (input.type === 'checkbox' && !input.checked) {
          input.classList.add('is-invalid');
          isValid = false;
        } else if ((input.type === 'text' || input.type === 'date') && !input.value.trim()) {
          input.classList.add('is-invalid');
          isValid = false;
        } else if (input.type === 'number' && (!input.value.trim() || isNaN(input.value))) {
          input.classList.add('is-invalid');
          isValid = false;
        } else if (input.tagName === 'SELECT' && !input.value) {
          input.classList.add('is-invalid');
          isValid = false;
        } else if (input.hasAttribute('maxlength') && input.value.length > input.maxLength) {
          input.classList.add('is-invalid');
          isValid = false;
        } else if (input.hasAttribute('minlength') && input.value.length < input.minLength) {
          input.classList.add('is-invalid');
          isValid = false;
        }
      });
      
      return isValid;
    }

    // Fungsi next step dengan validasi
    function validateAndNextStep() {
      if (validateCurrentStep()) {
        if (currentStep < steps.length - 1) {
          currentStep++;
          showStep(currentStep);
          window.scrollTo({ top: 0, behavior: 'smooth' });
        }
      } else {
        // Gulir ke input pertama yang error
        const firstInvalid = document.querySelector('.step.active .is-invalid');
        if (firstInvalid) {
          firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
          firstInvalid.focus();
        }
      }
    }

    // prev step
    function prevStep() {
      if (currentStep > 0) {
        currentStep--;
        showStep(currentStep);
        window.scrollTo({ top: 0, behavior: 'smooth' });
      }
    }

    // default step
    showStep(currentStep);

    // submit data
    document.getElementById('multiStepForm').addEventListener('submit', function(e) {
        if (currentStep === steps.length - 1 && !checkbox.checked) {
            e.preventDefault();
            checkbox.classList.add('is-invalid');
            alert('Anda harus menyetujui syarat dan ketentuan terlebih dahulu!');
            return;
        }
        
        if (currentStep === steps.length - 1) {
            e.preventDefault();
            
            // Mengumpulkan semua data form
            const formData = new FormData(document.getElementById('multiStepForm'));
            
            // Update progress bar ke 100% sebelum submit
            updateProgressBar(100);

            // Tampilkan loading spinner
            submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Mengirim...';
            submitBtn.disabled = true;
            
            // Kirim data via AJAX
            fetch('/store-jamaah', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.status) {
                    var kode_keberangkatan = data.kode_keberangkatan;
                    swal("Success!", "Registrasi berhasil Click OK untuk mendowlod data keberangkatan", "success")
                    .then(() => {
                      // Redirect ke route untuk download PDF
                      window.open(`/keberangkatan_pdf/${kode_keberangkatan}`, '_blank');
                    });
                    // Reset form
                    document.getElementById('multiStepForm').reset();
                    currentStep = 0;
                    showStep(currentStep);

                } else {
                    swal("Info!", data.message, "info");
                }
            })

            .catch(error => {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat mengirim data');
            })
            .finally(() => {
                submitBtn.innerHTML = '<span class="d-none d-md-inline">Kirim Form</span><span class="d-inline d-md-none">✓</span>';
                submitBtn.disabled = false;
            });
        }
    });

    // Fungsi untuk menginisialisasi popover
    function initPopovers() {
      const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
      popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl);
      });
    }

    document.addEventListener('DOMContentLoaded', function() {
      initPopovers();
      // Fungsi untuk mengaktifkan/menonaktifkan tombol submit
      checkbox.addEventListener('change', function() {
        submitBtn.disabled = !this.checked;
        this.classList.remove('is-invalid');
      });
    });

  </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/portal.blade.php ENDPATH**/ ?>