

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">
        <h1 class="mb-4">Detail Keberangkatan dan Jamaah</h1>

        <?php if($data): ?>
            <div class="row">
                <!-- Card untuk Data Jamaah -->
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h5>Data Jamaah</h5>
                        </div>
                        <div class="card-body">
                            <p><strong>Title:</strong> <?php echo e($data->title); ?></p>
                            <p><strong>Nama:</strong> <?php echo e($data->nama); ?></p>
                            <p><strong>No Passport:</strong> <?php echo e($data->no_passport); ?></p>
                            <p><strong>Tempat Lahir:</strong> <?php echo e($data->tempat_lahir); ?></p>
                            <p><strong>Tanggal Lahir:</strong> <?php echo e(\Carbon\Carbon::parse($data->tanggal_lahir)->format('d F Y')); ?></p>
                            <p><strong>Tempat Iss:</strong> <?php echo e($data->tempat_iss); ?></p>
                            <p><strong>No KTP:</strong> <?php echo e($data->no_ktp); ?></p>
                            <p><strong>Alamat:</strong> <?php echo e($data->alamat); ?></p>
                            <p><strong>RT/RW:</strong> <?php echo e($data->rt); ?>/<?php echo e($data->rw); ?></p>
                            <p><strong>Kelurahan:</strong> <?php echo e($data->kelurahan); ?></p>
                            <p><strong>Kecamatan:</strong> <?php echo e($data->kecamatan); ?></p>
                            <p><strong>Kota:</strong> <?php echo e($data->kota); ?></p>
                            <p><strong>Provinsi:</strong> <?php echo e($data->provinsi); ?></p>
                            <p><strong>Status Perkawinan:</strong> <?php echo e($data->status_perkawinan); ?></p>
                            <p><strong>Pekerjaan:</strong> <?php echo e($data->pekerjaan); ?></p>
                            <p><strong>Nama Ayah:</strong> <?php echo e($data->nama_ayah); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Card untuk Data Keberangkatan -->
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h5>Data Keberangkatan</h5>
                        </div>
                        <div class="card-body">
                            <p><strong>Kode Keberangkatan:</strong> <?php echo e($data->kode_keberangkatan); ?></p>
                            <p><strong>ID Afiliasi:</strong> <?php echo e($data->id_afiliasi); ?></p>
                            <p><strong>Tanggal Keberangkatan:</strong> <?php echo e(\Carbon\Carbon::parse($data->tanggal_keberangkatan)->format('d F Y')); ?></p>
                            <p><strong>Status Pembayaran:</strong> <?php echo e($data->status_pembayaran); ?></p>
                            <p><strong>Tanggal Pembayaran:</strong> <?php echo e(\Carbon\Carbon::parse($data->tanggal_pembayaran)->format('d F Y')); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tombol Kembali ke Daftar Keberangkatan -->
            <a href="<?php echo e(route('keberangkatan.index')); ?>" class="btn btn-primary">Kembali ke Daftar Keberangkatan</a>
        <?php else: ?>
            <div class="alert alert-danger">Data tidak ditemukan.</div>
        <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/keberangkatan/show.blade.php ENDPATH**/ ?>