<?php $__env->startSection('content'); ?>

<div class="container mt-4">
    <div class="d-flex justify-content-center align-items-center">
        <div class="col-md-12">

            
            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Navigasi Halaman
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo e(route('keberangkatan.index')); ?>">Keberangkatan</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('jamaah.index')); ?>">Jamaah</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('afiliat.index')); ?>">Affiliate</a></li>
                    </ul>
                </div>

                <form action="<?php echo e(route('keberangkatan.search')); ?>" method="POST" class="d-flex gap-2">
                    <?php echo csrf_field(); ?>
                    <input type="text" name="search" class="form-control" placeholder="Search keberangkatan..." value="<?php echo e(request('search')); ?>">
                    <button type="submit" class="btn btn-outline-primary">Go</button>
                </form>
            </div>

            
            <div class="row justify-content-center my-4">
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Jamaah</h5>
                            <h3><?php echo e($totalJamaah); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Keberangkatan</h5>
                            <h3><?php echo e($totalKeberangkatan); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Afiliasi</h5>
                            <h3><?php echo e($totalAfiliasi); ?></h3>
                        </div>
                    </div>
                </div>
            </div>


            
            <div class="row justify-content-center my-4">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">Data keberangkatan</div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-header">Top 10 afiliasi</div>
                        <div class="card-body">
                            <div class="card p-3">
                                <ul class="list-group list-group-flush">
                                    <?php $__currentLoopData = $topAfiliasis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $afiliasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <?php echo e($afiliasi->nama); ?>

                                            <span class="badge bg-primary rounded-pill"><?php echo e($afiliasi->jumlah); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="row justify-content-center mt-4">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">Jumlah Keberangkatan </div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart2"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">Total Keberangkatan</div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart3"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="row justify-content-center mt-4">
                <div class="col-md-12">
                    <div class="card">
                
                        <div class="card-header">Transaction</div>

                        <div class="card-body">
                            <?php if(session('status')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('status')); ?>

                                </div>
                            <?php endif; ?>

                            <!-- Membungkus tabel dengan table-responsive agar responsif di perangkat kecil -->
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>No</th>
                                            <th>No KTP</th>
                                            <th>Nama</th>
                                            <th>Kode Keberangkatan</th>
                                            <th>Tanggal Keberangkatan</th>
                                            <th>Status Pembayaran</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $keberangkatans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($item->no_ktp); ?></td>
                                                <td><?php echo e($item->nama); ?></td>
                                                <td><?php echo e($item->kode_keberangkatan); ?></td>
                                                <td><?php echo e(date('d F Y', strtotime($item->tanggal_keberangkatan))); ?></td>
                                                <td><?php echo e($item->status_pembayaran); ?></td>
                                                <td>
                                                <a href="#" class="btn btn-warning" onclick="approveKeberangkatan(<?php echo e($item->id); ?>)">
                                                    Approve
                                                </a>    
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div> <!-- end of table-responsive -->

                        </div>
                    </div>
                </div>
            </div>

        </div> 
    </div> 
</div> 

<script src="<?php echo e(asset('js/chart.js')); ?>"></script>
<script>
  const ctx = document.getElementById('myChart').getContext('2d');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: <?php echo json_encode($labels, 15, 512) ?>,
      datasets: [{
        label: 'Jumlah Keberangkatan',
        data: <?php echo json_encode($dataJumlah, 15, 512) ?>,
        borderColor: 'rgba(75, 192, 192, 1)',
        backgroundColor: 'rgba(75, 192, 192, 0.2)',
        tension: 0.3,
        borderWidth: 2,
        fill: true,
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          stepSize: 1
        }
      }
    }
  });
</script>

<script>
    const ctx2 = document.getElementById('myChart2').getContext('2d');

    new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($labels); ?>,
            datasets: <?php echo json_encode($datasetsJenisUmroh); ?>

        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    precision: 0
                }
            }
        }
    });
</script>

<script>
  const ctx3 = document.getElementById('myChart3');

  new Chart(ctx3, {
    type: 'pie',
    data: {
      labels: <?php echo json_encode(array_column($totalKeberangkatanAtJenisUmroh1Tahun, 'jenis_umroh')); ?>,
      datasets: [{
        label: 'Total Keberangkatan',
        data: <?php echo json_encode(array_column($totalKeberangkatanAtJenisUmroh1Tahun, 'total')); ?>,
        backgroundColor: [
          '#4dc9f6',
          '#f67019',
          '#f53794',
          '#537bc4',
          '#acc236',
          '#166a8f',
          '#00a950',
          '#58595b',
          '#8549ba'
        ],
        borderWidth: 1
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: {
          position: 'top',
        },
        title: {
          display: true,
          text: 'Total Keberangkatan per Jenis Umroh (Tahun Ini)'
        }
      }
    }
  });
</script>

<script>
    async function approveKeberangkatan(id) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const confirmResult = await swal({
            title: "Ubah Status Pembayaran",
            text: "Yakin ingin mengubah status pembayaran?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        });

        if (!confirmResult) return;

        try {
            const response = await fetch(`/keberangkatan/${id}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ id: id })
            });

            const data = await response.json();

            if (data.status) {
                swal("Berhasil!", 'Approve berhasil dilakukan', "success");
                location.reload();
            } else {
                swal("Gagal!", "Status gagal diperbarui.", "error");
            }
        } catch (error) {
            console.error('Error:', error);
            swal("Error!", "Terjadi kesalahan saat memproses permintaan.", "error");
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>