<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  <title>Formulir Data Jamaah</title>

  <!-- CSS Links -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

  <style>
    /* Step Styling */
    .step {
      display: none;
    }

    .step.active {
      display: block;
      animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Footer Styling */
    footer {
      background-color: #f8f9fa;
      padding: 15px 0;
      margin-top: 50px;
      text-align: center;
      font-size: 0.9rem;
      color: #666;
    }

    /* Input Validation Styling */
    .is-invalid {
      border-color: #dc3545 !important;
    }

    .invalid-feedback {
      color: #dc3545;
      font-size: 0.875em;
    }

    /* Prevent Number Input Arrows */
    input[type=number]::-webkit-inner-spin-button,
    input[type=number]::-webkit-outer-spin-button {
      -webkit-appearance: none;
      margin: 0;
    }

    input[type=number] {
      -moz-appearance: textfield;
    }

    /* Media Queries for Mobile */
    @media (max-width: 768px) {
      body {
        font-size: 14px;
      }

      .card-header h4 {
        font-size: 1.2rem;
      }

      .form-control,
      .form-select {
        padding: 0.375rem 0.75rem;
        font-size: 14px;
      }

      .btn {
        padding: 0.375rem 0.75rem;
        font-size: 14px;
      }

      .progress {
        height: 20px !important;
      }

      #step-title {
        font-size: 1rem;
      }

      footer {
        padding: 10px 0;
        font-size: 0.8rem;
      }
    }

    /* Info Icon Styling */
    .info-icon {
      color: #0d6efd;
      cursor: pointer;
      margin-left: 5px;
    }

    .info-icon:hover {
      color: #0b5ed7;
    }
  </style>
</head>

<body class="d-flex flex-column min-vh-100">

  <!-- Header -->
  <header class="bg-warning text-white text-center py-3">
    <nav class="navbar navbar-expand-lg navbar-light bg-warning">
      <div class="container-fluid">
      <a class="navbar-brand" href="https://elqoshwa.com/">ELQOSHWA</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav me-auto mb-2 mb-lg-0">
            <li class="nav-item">
              <a class="nav-link" aria-current="page" href="#">Home</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="<?php echo e(url('/')); ?>">Registrasi</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#">Search</a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  </header>

  <!-- Main Content -->
  <main class="flex-grow-1">
    <div class="container my-4">
        <div class="container">
            <!-- Card 1 -->
            <div class="card shadow-lg mb-4">
                <div class="card-header bg-white text-secondary text-center">
                    <h4>📝 Form Cek Id</h4>
                </div>
                <div class="card-body">

                    <!-- Form -->
                    <form id="cekIdJamaah">
                        <div class="mb-3">
                            <label class="form-label">NIK 
                                <i class="fas fa-info-circle info-icon" 
                                data-bs-toggle="popover" 
                                data-bs-placement="right"
                                data-bs-content="Isi jika Anda memiliki kode referal/referensi dari agen/marketing kami (opsional)"></i>
                            </label>
                            <input type="text" class="form-control" name="no_ktp" maxlength="16">
                            <small class="text-muted">(Opsional)</small>
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg">Cek Id</button>
                    </form>
                </div>
            </div>

            <!-- Card -->
            <div class="card shadow-lg mb-4" id="resultCard" style="display: none;">
                <div class="row g-0">
                    <div class="col-md-8">
                    <div class="card-body">
                        <h5 class="card-title" id="resultTitle">Card title</h5>
                        <p class="card-text" id="resultText">Lorem ipsum dolor sit amet consectetur, adipisicing elit.</p>
                        <p class="card-text"><small class="text-muted" id="resultTimestamp">Lorem ipsum</small></p>
                    </div>
                    </div>
                </div>
            </div>

            <!-- Card -->
            <div class="card shadow-lg mb-4" id="resultCardFailed" style="display: none;">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="card-title">Ups! NIK Belum Terdaftar</h5>
                        <p class="card-text">Sepertinya NIK yang Anda masukkan belum ada di database kami. Coba periksa kembali, ya. Jika masih bermasalah, silakan hubungi tim kami untuk bantuan.</p>
                        <!-- <a href="#" class="btn btn-primary">Go somewhere</a> -->
                    </div>
                </div>
            </div>

        </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="bg-light text-center py-3 mt-auto">
    Copyright © 2025 | elqoshwaprimawisata.online
  </footer>

  <script>
    document.getElementById('cekIdJamaah').addEventListener('submit', function(e) {
        e.preventDefault();

        const form = document.getElementById('cekIdJamaah');
        const formData = new FormData(form);
        const submitBtn = form.querySelector('button[type="submit"]');
        const resultCard = document.getElementById('resultCard');

        // Ubah tombol jadi loading
        submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Mengirim...';
        submitBtn.disabled = true;

        fetch('/cek-id-jamaah', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        }
        })
        .then(response => response.json())
        .then(data => {
        if (data.status) {
            // Isi data ke dalam card
            document.getElementById('resultTitle').textContent = data.result.nama || 'Tidak ada nama';

            resultCard.style.display = 'block';
            resultCardFailed.style.display = 'none';
        } else {
            console.log('data tidak ada');
            resultCard.style.display = 'none';
        }
        })
        .catch(error => {
        console.log('data tidak ada');
        resultCard.style.display = 'none';
        resultCardFailed.style.display = 'block';
        })
        .finally(() => {
        // Kembalikan tombol ke semula
        submitBtn.innerHTML = 'Cek Id';
        submitBtn.disabled = false;
        });
    });
</script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

</body>

</html>
<?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/cek-id-jamaah.blade.php ENDPATH**/ ?>