

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Edit Data Jamaah</h5>
                </div>
                <div class="card-body">

                    <form id="formEditAfiliasi">
                        <?php echo csrf_field(); ?>

                        <div class="row">

                            <div class="col-md-6 mb-3">
                                <label for="nama" class="form-label">Nama</label>
                                <input type="text" name="nama" class="form-control" maxlength="100" value="<?php echo e(old('nama', $afiliasi->nama)); ?>" require>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">Tempat Lahir</label>
                                <input type="text" name="email" class="form-control" maxlength="50" value="<?php echo e(old('email', $afiliasi->email)); ?>" require>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                                <input type="date" name="tanggal_lahir" class="form-control" value="<?php echo e(old('tanggal_lahir', $afiliasi->tanggal_lahir)); ?>" require>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="alamat" class="form-label">Alamat</label>
                                <textarea name="alamat" class="form-control" maxlength="255"><?php echo e(old('alamat', $afiliasi->alamat)); ?></textarea>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="no_telepon" class="form-label">No Telepon</label>
                                <input type="text" name="no_telepon" class="form-control" maxlength="16" value="<?php echo e(old('no_telepon', $afiliasi->no_telepon)); ?>" required minlength="16" maxlength="16" 
                                oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <div class="invalid-feedback">Harap isi No. KTP (16 digit angka)</div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="no_ktp" class="form-label">No KTP</label>
                                <input type="text" name="no_ktp" class="form-control" maxlength="16" value="<?php echo e(old('no_ktp', $afiliasi->no_ktp)); ?>" required minlength="7" maxlength="16" 
                                oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                <div class="invalid-feedback">No. Telepon harus 7-16 digit angka</div>
                        
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="kota" class="form-label">Kota</label>
                                <input type="text" name="kota" class="form-control" value="<?php echo e(old('kota', $afiliasi->kota)); ?>" require>
                            </div>

                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="<?php echo e(route('afiliat.index')); ?>" class="btn btn-secondary me-2">Kembali</a>
                            <button type="submit" class="btn btn-success">Simpan Perubahan</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>


<script>
document.getElementById('formEditAfiliasi').addEventListener('submit', async function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    // Tambahkan method PUT karena form pakai POST biasa
    formData.append('_method', 'PUT');

    try {
        const response = await fetch("<?php echo e(route('afiliat.update', $afiliasi->id)); ?>", {
            method: 'POST', // pakai POST karena kita override _method di body
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json',
            },
            body: formData
        });

        const result = await response.json();
        if (response.status) {
            swal("Success!", "Update berhasil,", "success");
        } else {
            swal("Failed!", "UPdate gagal, silakan download bukti PDF", "danger");
        }
    } catch (error) {
        console.error(error);
        alert('Gagal mengirim data ke server.');
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projeck\elqoshwaprimawisata\resources\views/afiliasi/edit.blade.php ENDPATH**/ ?>