<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\JamaahController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\KeberangkatanController;
use App\Http\Controllers\AfiliasiController;
use App\Http\Controllers\PortalController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [PortalController::class, 'registrasi'])->name('portal.registrasi');
Route::get('/keberangkatan_pdf/{kode_keberangkatan}', [PortalController::class, 'download_data_keberangkatan'])->name('jamaah.download_data_keberangkatan');

Route::post('/store-jamaah', [JamaahController::class, 'store'])->name('jamaah.store');

Route::get('/cek_id_jamaah', function () {
    return view('cek_id_jamaah');
});

Route::post('/cek_kode_keberangkatan', [JamaahController::class, 'cek'])->name('jamaah.cek');

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/home', [HomeController::class, 'index'])->name('home');

// Route::post('/jamaah/store', [JamaahController::class, 'store']);
Route::resource('/jamaah', JamaahController::class);
Route::resource('/keberangkatan', KeberangkatanController::class);
Route::resource('/afiliat', AfiliasiController::class);

// Auth::routes();
Route::post('/keberangkatan/search', [KeberangkatanController::class, 'search'])->name('keberangkatan.search');
Route::post('/keberangkatan/{id}/approve', [KeberangkatanController::class, 'approve'])->name('keberangkatan.approve');
Route::post('/keberangkatan/export', [KeberangkatanController::class, 'export'])->name('keberangkatan.export');

Route::post('/jamaah/search', [JamaahController::class, 'search'])->name('jamaah.search');
Route::post('/jamaah/export', [JamaahController::class, 'export'])->name('jamaah.export');

Route::post('/afiliat/search', [AfiliasiController::class, 'search'])->name('afiliat.search');
Route::post('/afiliat/export', [AfiliasiController::class, 'export'])->name('afiliat.export');

