@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">
        <h1 class="mb-4">Detail Keberangkatan dan Jamaah</h1>

        @if ($data)
            <div class="row">
                <!-- Card untuk Data Jamaah -->
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h5>Data Jamaah</h5>
                        </div>
                        <div class="card-body">
                            <p><strong>Title:</strong> {{ $data->title }}</p>
                            <p><strong>Nama:</strong> {{ $data->nama }}</p>
                            <p><strong>No Passport:</strong> {{ $data->no_passport }}</p>
                            <p><strong>Tempat Lahir:</strong> {{ $data->tempat_lahir }}</p>
                            <p><strong>Tanggal Lahir:</strong> {{ \Carbon\Carbon::parse($data->tanggal_lahir)->format('d F Y') }}</p>
                            <p><strong>Tempat Iss:</strong> {{ $data->tempat_iss }}</p>
                            <p><strong>No KTP:</strong> {{ $data->no_ktp }}</p>
                            <p><strong>Alamat:</strong> {{ $data->alamat }}</p>
                            <p><strong>RT/RW:</strong> {{ $data->rt }}/{{ $data->rw }}</p>
                            <p><strong>Kelurahan:</strong> {{ $data->kelurahan }}</p>
                            <p><strong>Kecamatan:</strong> {{ $data->kecamatan }}</p>
                            <p><strong>Kota:</strong> {{ $data->kota }}</p>
                            <p><strong>Provinsi:</strong> {{ $data->provinsi }}</p>
                            <p><strong>Status Perkawinan:</strong> {{ $data->status_perkawinan }}</p>
                            <p><strong>Pekerjaan:</strong> {{ $data->pekerjaan }}</p>
                            <p><strong>Nama Ayah:</strong> {{ $data->nama_ayah }}</p>
                        </div>
                    </div>
                </div>

                <!-- Card untuk Data Keberangkatan -->
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h5>Data Keberangkatan</h5>
                        </div>
                        <div class="card-body">
                            <p><strong>Kode Keberangkatan:</strong> {{ $data->kode_keberangkatan }}</p>
                            <p><strong>ID Afiliasi:</strong> {{ $data->id_afiliasi }}</p>
                            <p><strong>Tanggal Keberangkatan:</strong> {{ \Carbon\Carbon::parse($data->tanggal_keberangkatan)->format('d F Y') }}</p>
                            <p><strong>Status Pembayaran:</strong> {{ $data->status_pembayaran }}</p>
                            <p><strong>Tanggal Pembayaran:</strong> {{ \Carbon\Carbon::parse($data->tanggal_pembayaran)->format('d F Y') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tombol Kembali ke Daftar Keberangkatan -->
            <a href="{{ route('keberangkatan.index') }}" class="btn btn-primary">Kembali ke Daftar Keberangkatan</a>
        @else
            <div class="alert alert-danger">Data tidak ditemukan.</div>
        @endif
        </div>
    </div>
</div>
@endsection
