@extends('layouts.admin.app')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">

            {{-- Notifikasi --}}
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">{{ session('error') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Toolbar --}}
            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <div class="d-flex gap-2 flex-wrap">
                    <a href="{{ route('keberangkatan.create') }}" class="btn btn-primary">Add New</a>
                    <a href="#" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exportModal">Export</a>
                    <a href="#" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#filterModal">Filter</a>
                </div>
                <form action="{{ route('keberangkatan.search') }}" method="POST" class="d-flex gap-2">
                    @csrf
                    <input type="text" name="search" class="form-control" placeholder="Search..." value="{{ request('search') }}">
                    <button type="submit" class="btn btn-outline-primary">Go</button>
                </form>
            </div>

            {{-- Card & Table --}}
            <div class="card">
                <div class="card-header">Transaction</div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Type Umroh</th>
                                    <th>No KTP</th>
                                    <th>Kode Keberangkatan</th>
                                    <th>Tanggal Keberangkatan</th>
                                    <th>Status Pembayaran</th>
                                    <th>Action Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data as $item)
                                    <tr>
                                        <td>{{ $loop->iteration + ($data->currentPage() - 1) * $data->perPage() }}</td>
                                        <td>
                                            @if($item->jenis_umroh == 1)
                                                Reguler
                                            @elseif($item->jenis_umroh == 2)
                                                Plus
                                            @endif
                                        </td>
                                        <td>{{ $item->no_ktp }}</td>
                                        <td>{{ $item->kode_keberangkatan }}</td>
                                        <td>{{ date('d F Y', strtotime($item->tanggal_keberangkatan)) }}</td>
                                        <td>{{ $item->status_pembayaran }}</td>
                                        <td>
                                            @if($item->status_pembayaran === 'Lunas')
                                                <a href="#" class="btn btn-warning btn-sm" onclick="approveKeberangkatan({{ $item->id }})">
                                                    Un Approve
                                                </a>
                                            @elseif($item->status_pembayaran === 'Tabungan' || $item->status_pembayaran === 'Belum Lunas')
                                                <a href="#" class="btn btn-success btn-sm" onclick="approveKeberangkatan({{ $item->id }})">
                                                    Approve
                                                </a>
                                            @endif
                                        </td>
                                        <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <a href="{{ route('keberangkatan.edit', $item->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="{{ route('keberangkatan.show', $item->no_ktp) }}" class="btn btn-primary btn-sm">Lihat</a>
                                            <form action="{{ route('keberangkatan.destroy', $item->id) }}" method="POST" id="delete-form-{{ $item->id }}" style="display: none;">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                            <button type="button" class="btn btn-danger btn-sm" onclick="confirmDelete({{ $item->id }})">Delete</button>
                                        </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            {{-- Paginate --}}
            @if ($data->lastPage() > 1)
                <div class="mt-3 d-flex">
                    <ul class="pagination flex-wrap">
                        <li class="page-item {{ ($data->currentPage() == 1) ? ' disabled' : '' }}">
                            <a class="page-link" href="{{ $data->url(1) }}">Previous</a>
                        </li>
                        @for ($i = 1; $i <= $data->lastPage(); $i++)
                            <li class="page-item {{ ($data->currentPage() == $i) ? ' active' : '' }}">
                                <a class="page-link" href="{{ $data->url($i) }}">{{ $i }}</a>
                            </li>
                        @endfor
                        <li class="page-item {{ ($data->currentPage() == $data->lastPage()) ? ' disabled' : '' }}">
                            <a class="page-link" href="{{ $data->url($data->currentPage()+1) }}">Next</a>
                        </li>
                    </ul>
                </div>
            @endif

        </div>
    </div>
</div>

<!-- Modal Filter -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="{{ route('keberangkatan.index') }}" method="GET" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filterModalLabel">Filter Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="tanggal_keberangkatan" class="form-label">Tanggal Keberangkatan</label>
          <input type="date" name="tanggal_keberangkatan" id="tanggal_keberangkatan" class="form-control" value="{{ request('tanggal_keberangkatan') }}">
        </div>
        <div class="mb-3">
            <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
            <select class="form-select" id="status_pembayaran" name="status_pembayaran">
                <option value="">-- Pilih Status --</option>
                <option value="Belum Lunas">Belum Lunas</option>
                <option value="Lunas">Lunas</option>
                <option value="Pending">Pending</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Terapkan Filter</button>
      </div>
    </form>
  </div>
</div>


<!-- Modal Export -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="{{ route('keberangkatan.export') }}" method="POST" class="modal-content">
    @csrf
      <div class="modal-header">
        <h5 class="modal-title" id="exportModalLabel">Export Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="tanggal_keberangkatan" class="form-label">Tanggal Keberangkatan</label>
          <input type="date" name="tanggal_keberangkatan" id="tanggal_keberangkatan" class="form-control" value="{{ request('tanggal_keberangkatan') }}">
        </div>
        <div class="mb-3">
            <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
            <select class="form-select" id="status_pembayaran" name="status_pembayaran">
                <option value="">-- Pilih Status --</option>
                <option value="Belum Lunas">Belum Lunas</option>
                <option value="Lunas">Lunas</option>
                <option value="Pending">Pending</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Export</button>
      </div>
    </form>
  </div>
</div>


<script>
    async function approveKeberangkatan(id) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const confirmResult = await swal({
            title: "Ubah Status Pembayaran",
            text: "Yakin ingin mengubah status pembayaran?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        });

        if (!confirmResult) return;

        try {
            const response = await fetch(`/keberangkatan/${id}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ id: id })
            });

            const data = await response.json();

            if (data.status) {
                swal("Berhasil!", 'Approve berhasil dilakukan', "success");
                location.reload();
            } else {
                swal("Gagal!", "Status gagal diperbarui.", "error");
            }
        } catch (error) {
            console.error('Error:', error);
            swal("Error!", "Terjadi kesalahan saat memproses permintaan.", "error");
        }
    }

    function confirmDelete(id) {
        // Menampilkan konfirmasi sebelum menghapus data
        swal({
            title: "Apakah Anda yakin?",
            text: "Data keberangkatan ini akan dihapus!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        .then((willDelete) => {
            if (willDelete) {
                // Jika pengguna mengonfirmasi, kirimkan form
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }


</script>
@endsection
