@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">

            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Detail Jamaah</h4>
                </div>
                <div class="card-body">
                    @if ($data)
                        <table class="table table-bordered">
                            <tbody>
                                <tr><th>Title</th><td>{{ $data->title }}</td></tr>
                                <tr><th>Nama</th><td>{{ $data->nama }}</td></tr>
                                <tr><th>No. Passport</th><td>{{ $data->no_passport ?? '-' }}</td></tr>
                                <tr><th>Tempat Lahir</th><td>{{ $data->tempat_lahir }}</td></tr>
                                <tr><th>Tanggal Lahir</th><td>{{ $data->tanggal_lahir }}</td></tr>
                                <tr><th>Tanggal Passport Issued</th><td>{{ $data->tanggal_iss ?? '-' }}</td></tr>
                                <tr><th>Tanggal Passport Expired</th><td>{{ $data->tanggal_expired ?? '-' }}</td></tr>
                                <tr><th>Tempat Passport Issued</th><td>{{ $data->tempat_iss ?? '-' }}</td></tr>
                                <tr><th>No. KTP</th><td>{{ $data->no_ktp }}</td></tr>
                                <tr><th>Alamat</th><td>{{ $data->alamat }}</td></tr>
                                <tr><th>RT</th><td>{{ $data->rt }}</td></tr>
                                <tr><th>RW</th><td>{{ $data->rw }}</td></tr>
                                <tr><th>Kelurahan</th><td>{{ $data->kelurahan }}</td></tr>
                                <tr><th>Kecamatan</th><td>{{ $data->kecamatan }}</td></tr>
                                <tr><th>Kota</th><td>{{ $data->kota }}</td></tr>
                                <tr><th>Provinsi</th><td>{{ $data->provinsi }}</td></tr>
                                <tr><th>Status Perkawinan</th><td>{{ $data->status_perkawinan }}</td></tr>
                                <tr><th>Pekerjaan</th><td>{{ $data->pekerjaan }}</td></tr>
                                <tr><th>Nama Ayah</th><td>{{ $data->nama_ayah }}</td></tr>
                            </tbody>
                        </table>
                        <a href="{{ url()->previous() }}" class="btn btn-secondary mt-3">Kembali</a>
                    @else
                        <p class="text-danger">Data jamaah tidak ditemukan.</p>
                        <a href="{{ url()->previous() }}" class="btn btn-secondary mt-3">Kembali</a>
                    @endif
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
