@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Edit Data Jamaah</h5>
                </div>
                <div class="card-body">

                    <form id="formEditJamaah">
                        @csrf

                        <div class="row">

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Mr/Mrs</label>
                                <select class="form-select" name="title" required>
                                    <option value="">Pilih...</option>
                                    <option value="Mr" {{ old('title', $jamaah->title) == 'Mr' ? 'selected' : '' }}>Mr</option>
                                    <option value="Mrs" {{ old('title', $jamaah->title) == 'Mrs' ? 'selected' : '' }}>Mrs</option>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="nama" class="form-label">Nama</label>
                                <input type="text" name="nama" class="form-control" maxlength="100" value="{{ old('nama', $jamaah->nama) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                                <input type="text" name="tempat_lahir" class="form-control" maxlength="50" value="{{ old('tempat_lahir', $jamaah->tempat_lahir) }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                                <input type="date" name="tanggal_lahir" class="form-control" value="{{ old('tanggal_lahir', $jamaah->tanggal_lahir) }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="no_ktp" class="form-label">No KTP</label>
                                <input type="text" name="no_ktp" class="form-control" maxlength="16" value="{{ old('no_ktp', $jamaah->no_ktp) }}" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="id_afiliasi" class="form-label">Id Afiliasi</label>
                                <input type="text" name="id_afiliasi" class="form-control" maxlength="10" value="{{ old('id_afiliasi', $jamaah->id_afiliasi) }}" required>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="alamat" class="form-label">Alamat</label>
                                <textarea name="alamat" class="form-control" maxlength="255">{{ old('alamat', $jamaah->alamat) }}</textarea>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">RT</label>
                                <input type="number" class="form-control" name="rt" required maxlength="3"
                                    value="{{ old('rt', $jamaah->rt) }}"
                                    oninput="if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                <div class="invalid-feedback">Harap isi RT (maks. 3 digit)</div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">RW</label>
                                <input type="number" class="form-control" name="rw" required maxlength="3"
                                    value="{{ old('rw', $jamaah->rw) }}"
                                    oninput="if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                <div class="invalid-feedback">Harap isi RW (maks. 3 digit)</div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="kelurahan" class="form-label">Kelurahan</label>
                                <input type="text" name="kelurahan" class="form-control" maxlength="50" value="{{ old('kelurahan', $jamaah->kelurahan) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="kecamatan" class="form-label">Kecamatan</label>
                                <input type="text" name="kecamatan" class="form-control" maxlength="50" value="{{ old('kecamatan', $jamaah->kecamatan) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="kota" class="form-label">Kota</label>
                                <input type="text" name="kota" class="form-control" maxlength="50" value="{{ old('kota', $jamaah->kota) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="provinsi" class="form-label">Provinsi</label>
                                <input type="text" name="provinsi" class="form-control" maxlength="50" value="{{ old('provinsi', $jamaah->provinsi) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status_perkawinan" required>
                                    <option value="">Pilih Status...</option>
                                    <option value="kawin" {{ old('status_perkawinan', $jamaah->status_perkawinan) == 'kawin' ? 'selected' : '' }}>Kawin</option>
                                    <option value="belum kawin" {{ old('status_perkawinan', $jamaah->status_perkawinan) == 'belum kawin' ? 'selected' : '' }}>Belum Kawin</option>
                                    <option value="cerai hidup" {{ old('status_perkawinan', $jamaah->status_perkawinan) == 'cerai hidup' ? 'selected' : '' }}>Cerai Hidup</option>
                                    <option value="cerai mati" {{ old('status_perkawinan', $jamaah->status_perkawinan) == 'cerai mati' ? 'selected' : '' }}>Cerai Mati</option>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="pekerjaan" class="form-label">Pekerjaan</label>
                                <input type="text" name="pekerjaan" class="form-control" maxlength="50" value="{{ old('pekerjaan', $jamaah->pekerjaan) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="nama_ayah" class="form-label">Nama Ayah</label>
                                <input type="text" name="nama_ayah" class="form-control" maxlength="100" value="{{ old('nama_ayah', $jamaah->nama_ayah) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="nama_ayah" class="form-label">Nama Ayah</label>
                                <input type="text" name="nama_ayah" class="form-control" maxlength="100"
                                    value="{{ old('nama_ayah', $jamaah->nama_ayah) }}" required>
                            </div>

                            <!-- 1. No Passport -->
                            <div class="col-md-6 mb-3">
                                <label for="no_passport" class="form-label">No Passport</label>
                                <input type="text" name="no_passport" class="form-control" maxlength="25"
                                    value="{{ old('no_passport', $jamaah->no_passport) }}">
                            </div>

                            <!-- 2. Tanggal Issued Passport -->
                            <div class="col-md-4 mb-3">
                                <label for="tanggal_iss" class="form-label">Tanggal Issued Passport</label>
                                <input type="date" name="tanggal_iss" class="form-control"
                                    value="{{ old('tanggal_iss', $jamaah->tanggal_iss) }}">
                            </div>

                            <!-- 3. Tanggal Expired Passport -->
                            <div class="col-md-4 mb-3">
                                <label for="tanggal_expired" class="form-label">Tanggal Expired Passport</label>
                                <input type="date" name="tanggal_expired" class="form-control"
                                    value="{{ old('tanggal_expired', $jamaah->tanggal_expired) }}">
                            </div>

                            <!-- 4. Tempat Issued Passport -->
                            <div class="col-md-4 mb-3">
                                <label for="tempat_iss" class="form-label">Tempat Issued Passport</label>
                                <input type="text" name="tempat_iss" class="form-control" maxlength="255"
                                    value="{{ old('tempat_iss', $jamaah->tempat_iss) }}">
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="{{ route('jamaah.index') }}" class="btn btn-secondary me-2">Kembali</a>
                            <button type="submit" class="btn btn-success">Simpan Perubahan</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>


<script>
document.getElementById('formEditJamaah').addEventListener('submit', async function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    // Tambahkan method PUT karena form pakai POST biasa
    formData.append('_method', 'PUT');

    try {
        const response = await fetch("{{ route('jamaah.update', $jamaah->no_ktp) }}", {
            method: 'POST', // pakai POST karena kita override _method di body
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
            },
            body: formData
        });

        const data = await response.json();
        if (data.status) {
            swal("Success!", "Update berhasil,", "success");
        } else {
            swal("Failed!", "UPdate gagal, silakan download bukti PDF", "danger");
        }
    } catch (error) {
        console.error(error);
        alert('Gagal mengirim data ke server.');
    }
});
</script>

@endsection
