@extends('layouts.app')

@section('content')

<!-- header -->
@include('layouts.header')

  <!-- Main Content -->
  <main class="flex-grow-1">
    <div class="container my-4">
      <div class="container">
        <!-- Card 1 -->
        <div class="card shadow-lg mb-4">
          <div class="card-header">
            <h4>📝 Form Cek Kode Keberangkatan</h4>
          </div>
          <div class="card-body">

            <!-- Form -->
            <form id="cekKodeKeberangkatan">
              <div class="mb-3">
                <label class="form-label">Kode Keberangkatan 
                  <i class="fas fa-info-circle info-icon" 
                    data-bs-toggle="popover" 
                    data-bs-placement="right"
                    data-bs-content="Isi jika Anda memiliki kode keberangkatan yang diberikan oleh agen kami (opsional)"></i>
                </label>
                <input type="text" class="form-control" name="kode_keberangkatan" maxlength="16">
                <small class="text-muted">(Opsional)</small>
              </div>
              <button type="submit" class="btn btn-primary btn-lg">Cek Kode</button>
            </form>
          </div>
        </div>

        <!-- Card 2 - Result -->
        <div class="card shadow-lg mb-4" id="resultCard" style="display: none;">
          <div class="card-header bg-success text-white">
            <h5 class="card-title">Data Ditemukan</h5>
          </div>
          <div class="card-body">
            <p class="card-text" id="resultText">Loading...</p>
            <p class="card-text"><small class="text-muted">Hubungi admin untuk melakukan pembayaran</small></p>
          </div>
        </div>

        <!-- Card 3 - Failed -->
        <div class="card shadow-lg mb-4" id="resultCardFailed" style="display: none;">
          <div class="card-header bg-danger text-white">
            <h5 class="card-title">Ups! Kode Keberangkatan Belum Terdaftar</h5>
          </div>
          <div class="card-body">
            <p class="card-text">Sepertinya kode keberangkatan yang Anda masukkan belum ada di database kami. Coba periksa kembali, ya. Jika masih bermasalah, silakan hubungi tim kami untuk bantuan.</p>
          </div>
        </div>

      </div>
    </div>
  </main>

<!-- footer -->
@include('layouts.footer')

<script>
  document.getElementById('cekKodeKeberangkatan').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = document.getElementById('cekKodeKeberangkatan');
    const formData = new FormData(form);
    const submitBtn = form.querySelector('button[type="submit"]');
    const resultCard = document.getElementById('resultCard');
    const resultCardFailed = document.getElementById('resultCardFailed');

    // Ubah tombol jadi loading
    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Mengirim...';
    submitBtn.disabled = true;

    fetch('/cek_kode_keberangkatan', {
      method: 'POST',
      body: formData,
      headers: {
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        'Accept': 'application/json'
      }
    })
    .then(response => response.json())
    .then(data => {
      if (data.status) {
        // Isi data ke dalam card
        const kodeKeberangkatan = data.result.kode_keberangkatan;
        
        // Menampilkan kode keberangkatan dalam huruf kapital dan tebal
        const formattedKodeKeberangkatan = kodeKeberangkatan.replace(/[A-Za-z]/g, function(match) {
          return match.toUpperCase();
        });

        document.getElementById('resultText').innerHTML = 
          'Kode Keberangkatan: <strong class="uppercase">' + formattedKodeKeberangkatan + '</strong>' + 
          ', Tanggal Keberangkatan: ' + data.result.tanggal_keberangkatan + 
          ', Status Pembayaran: ' + data.result.status_pembayaran;
          
        // Menampilkan card dan menyembunyikan card gagal
        document.getElementById('resultCard').style.display = 'block';
        document.getElementById('resultCardFailed').style.display = 'none';
      } else {
        console.log('Data tidak ada');
        document.getElementById('resultCard').style.display = 'none';
        document.getElementById('resultCardFailed').style.display = 'block';
      }
    })
    .catch(error => {
      console.log('Error:', error);
      document.getElementById('resultCard').style.display = 'none';
      document.getElementById('resultCardFailed').style.display = 'block';
    })
    .finally(() => {
      submitBtn.innerHTML = 'Cek Kode';
      submitBtn.disabled = false;
    });
  });
</script>
