@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">

            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Detail Afiliasi</h4>
                </div>
                <div class="card-body">
                        <table class="table table-bordered">
                            <tbody>
                                <tr><th>ID</th><td>{{ $afiliasi->id }}</td></tr>
                                <tr><th>Nama</th><td>{{ $afiliasi->nama }}</td></tr>
                                <tr><th>Email</th><td>{{ $afiliasi->email }}</td></tr>
                                <tr><th>Tanggal Lahir</th><td>{{ \Carbon\Carbon::parse($afiliasi->tanggal_lahir)->format('d F Y') }}</td></tr>
                                <tr><th>Alamat</th><td>{{ $afiliasi->alamat }}</td></tr>
                                <tr><th>No. Telepon</th><td>{{ $afiliasi->no_telepon }}</td></tr>
                                <tr><th>No. KTP</th><td>{{ $afiliasi->no_ktp }}</td></tr>
                                <tr><th>Kode Afiliasi</th><td>{{ $afiliasi->kode_afiliasi }}</td></tr>
                                <tr><th>Kota</th><td>{{ $afiliasi->kota }}</td></tr>
                                <tr><th>Tanggal Dibuat</th><td>{{ \Carbon\Carbon::parse($afiliasi->created_at)->format('d F Y H:i') }}</td></tr>
                                <tr><th>Terakhir Diupdate</th><td>{{ \Carbon\Carbon::parse($afiliasi->updated_at)->format('d F Y H:i') }}</td></tr>
                            </tbody>
                        </table>
                        <a href="{{ url()->previous() }}" class="btn btn-secondary mt-3">Kembali</a>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection