@extends('layouts.admin.app')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">

            {{-- Notifikasi --}}
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">{{ session('error') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Toolbar --}}
            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <div class="d-flex gap-2 flex-wrap">
                    <a href="{{ route('afiliat.create') }}" class="btn btn-primary">Add</a>
                    <a href="#" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exportModal">Export</a>
                    <a href="#" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#filterModal">Filter</a>
                </div>
                <form action="{{ route('afiliat.search') }}" method="POST" class="d-flex gap-2">
                    @csrf
                    <input type="text" name="search" class="form-control" placeholder="Search..." value="{{ request('search') }}">
                    <button type="submit" class="btn btn-outline-primary">Go</button>
                </form>
            </div>

            {{-- Card & Table --}}
            <div class="card">
                <div class="card-header">Transaction</div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama</th>
                                    <th>NIK</th>
                                    <th>Kode Afiliat</th>
                                    <th>Jumlah Keberangkatan</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $item)
                                <tr>
                                    <td>{{ $loop->iteration + ($data->currentPage() - 1) * $data->perPage() }}</td>
                                    <td>{{ $item->nama }}</td>
                                    <td>{{ $item->no_ktp }}</td>
                                    <td>{{ $item->kode_afiliasi }}</td>
                                    <td>{{ $item->jumlah_keberangkatan }}</td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <a href="{{ route('afiliat.edit', $item->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="{{ route('afiliat.show', $item->id) }}" class="btn btn-primary btn-sm">Lihat</a>
                                            <form action="{{ route('afiliat.destroy', $item->id) }}" method="POST" id="delete-form-{{ $item->id }}" style="display: none;">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                            <button type="button" class="btn btn-danger btn-sm" onclick="confirmDelete({{ $item->id }})">Delete</button>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            {{-- Paginate --}}
            @if ($data->lastPage() > 1)
                <div class="mt-3 d-flex">
                    <ul class="pagination flex-wrap">
                        <li class="page-item {{ ($data->currentPage() == 1) ? ' disabled' : '' }}">
                            <a class="page-link" href="{{ $data->url(1) }}">Previous</a>
                        </li>
                        @for ($i = 1; $i <= $data->lastPage(); $i++)
                            <li class="page-item {{ ($data->currentPage() == $i) ? ' active' : '' }}">
                                <a class="page-link" href="{{ $data->url($i) }}">{{ $i }}</a>
                            </li>
                        @endfor
                        <li class="page-item {{ ($data->currentPage() == $data->lastPage()) ? ' disabled' : '' }}">
                            <a class="page-link" href="{{ $data->url($data->currentPage()+1) }}">Next</a>
                        </li>
                    </ul>
                </div>
            @endif

        </div>
    </div>
</div>

<!-- Modal Filter -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="{{ route('afiliat.index') }}" method="GET" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filterModalLabel">Filter Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="kota" class="form-label">Kota</label>
          <input type="text" name="kota" id="kota" class="form-control" value="{{ request('kota') }}">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Terapkan Filter</button>
      </div>
    </form>
  </div>
</div>


<!-- Modal Export -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form action="{{ route('afiliat.export') }}" method="POST" class="modal-content">
    @csrf
      <div class="modal-header">
        <h5 class="modal-title" id="exportModalLabel">Export Data</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="form-row">
          <div class="col">
            <label for="start_tanggal" class="form-label">Start tanggal register</label>
            <input type="date" class="form-control" id="start_tanggal" name="start_tanggal">
          </div>
          <div class="col">
            <label for="end_tanggal" class="form-label">End tanggal register</label>
            <input type="date" class="form-control" id="end_tanggal" name="end_tanggal">
          </div>
        </div>
        <div class="mb-3">
          <label for="kota" class="form-label">Kota</label>
          <input type="text" name="kota" id="kota" class="form-control" value="{{ request('kota') }}">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Export</button>
      </div>
    </form>
  </div>
</div>

<script>
  
    function confirmDelete(id) {
        // Menampilkan konfirmasi sebelum menghapus data
        swal({
            title: "Apakah Anda yakin?",
            text: "Data keberangkatan ini akan dihapus!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        .then((willDelete) => {
            if (willDelete) {
                // Jika pengguna mengonfirmasi, kirimkan form
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }


</script>
@endsection
