@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h4>Tambah Afiliasi</h4>
                </div>
                <div class="card-body">
                    <form id="formAfiliasi">
                        @csrf
                        <div class="mb-3">
                            <label for="nama" class="form-label">Nama</label>
                            <input type="text" class="form-control" id="nama" name="nama" required>
                            <div class="invalid-feedback">Nama wajib diisi</div>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                            <div class="invalid-feedback">Email wajib diisi dan harus valid</div>
                        </div>
                        <div class="mb-3">
                            <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                            <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" required>
                            <div class="invalid-feedback">Tanggal lahir wajib diisi</div>
                        </div>
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat</label>
                            <textarea class="form-control" id="alamat" name="alamat" required></textarea>
                            <div class="invalid-feedback">Alamat wajib diisi</div>
                        </div>
                        <div class="mb-3">
                            <label for="no_ktp" class="form-label">No. KTP</label>
                            <input type="number" class="form-control" id="no_ktp" name="no_ktp" required 
                                minlength="16" maxlength="16" 
                                oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <div class="invalid-feedback">Harap isi No. KTP (16 digit angka)</div>
                        </div>
                        <div class="mb-3">
                            <label for="no_telepon" class="form-label">No. Telepon</label>
                            <input type="number" class="form-control" id="no_telepon" name="no_telepon" required 
                                minlength="7" maxlength="16" 
                                oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <div class="invalid-feedback">No. Telepon harus 7-16 digit angka</div>
                        </div>
                        <div class="mb-3">
                            <label for="kota" class="form-label">Kota</label>
                            <input type="text" class="form-control" id="kota" name="kota" required>
                            <div class="invalid-feedback">Kota wajib diisi</div>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>

                    <div id="notif" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('formAfiliasi').addEventListener('submit', async function(e) {
    e.preventDefault();
    const form = e.target;
    const notif = document.getElementById('notif');
    
    // Reset notifikasi dan validasi
    notif.innerHTML = '';
    document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));

    // Validasi client-side
    let isValid = true;
    const requiredFields = ['nama', 'email', 'tanggal_lahir', 'alamat', 'no_ktp', 'no_telepon', 'kota'];
    
    requiredFields.forEach(field => {
        const input = document.getElementById(field);
        if (!input.value.trim()) {
            input.classList.add('is-invalid');
            isValid = false;
        }
    });

    // Validasi format KTP
    const noKtp = document.getElementById('no_ktp');
    if (noKtp.value && !/^\d{16}$/.test(noKtp.value)) {
        noKtp.classList.add('is-invalid');
        isValid = false;
    }

    // Validasi format telepon
    const noTelepon = document.getElementById('no_telepon');
    if (noTelepon.value && !/^\d{7,16}$/.test(noTelepon.value)) {
        noTelepon.classList.add('is-invalid');
        isValid = false;
    }

    // Validasi format email
    const email = document.getElementById('email');
    if (email.value && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email.value)) {
        email.classList.add('is-invalid');
        isValid = false;
    }

    if (!isValid) {
        notif.innerHTML = '<div class="alert alert-danger">Terdapat kesalahan dalam form. Silakan periksa kembali.</div>';
        return;
    }

    try {
        // Kirim data jika validasi lolos
        const formData = new FormData(form);
        const response = await fetch("{{ route('afiliat.store') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(Object.fromEntries(formData))
        });

        const data = await response.json();

        if (response.status) {
            swal("Success!", "Create berhasil,", "success");
        } else {
            swal("Failed!", "Create gagal", "danger");
        }
    } catch (error) {
        console.error('Error:', error);
        notif.innerHTML = '<div class="alert alert-danger">Terjadi kesalahan saat mengirim data</div>';
    }
});
</script>
@endsection