@extends('layouts.admin.app')

@section('content')

<div class="container mt-4">
    <div class="d-flex justify-content-center align-items-center">
        <div class="col-md-12">

            {{-- Header Aksi dan Search --}}
            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Navigasi Halaman
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('keberangkatan.index') }}">Keberangkatan</a></li>
                        <li><a class="dropdown-item" href="{{ route('jamaah.index') }}">Jamaah</a></li>
                        <li><a class="dropdown-item" href="{{ route('afiliat.index') }}">Affiliate</a></li>
                    </ul>
                </div>

                <form action="{{ route('keberangkatan.search') }}" method="POST" class="d-flex gap-2">
                    @csrf
                    <input type="text" name="search" class="form-control" placeholder="Search keberangkatan..." value="{{ request('search') }}">
                    <button type="submit" class="btn btn-outline-primary">Go</button>
                </form>
            </div>

            {{-- 3 Kolom Konten --}}
            <div class="row justify-content-center my-4">
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Jamaah</h5>
                            <h3>{{ $totalJamaah }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Keberangkatan</h5>
                            <h3>{{ $totalKeberangkatan }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">Total Afiliasi</h5>
                            <h3>{{ $totalAfiliasi }}</h3>
                        </div>
                    </div>
                </div>
            </div>


            {{-- Chart Jamaah & Top 5 List --}}
            <div class="row justify-content-center my-4">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">Data keberangkatan</div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-header">Top 10 afiliasi</div>
                        <div class="card-body">
                            <div class="card p-3">
                                <ul class="list-group list-group-flush">
                                    @foreach ($topAfiliasis as $afiliasi)
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            {{ $afiliasi->nama }}
                                            <span class="badge bg-primary rounded-pill">{{ $afiliasi->jumlah }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Chart Tambahan --}}
            <div class="row justify-content-center mt-4">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">Jumlah Keberangkatan </div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart2"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">Total Keberangkatan</div>
                        <div class="card-body">
                            <div class="card p-4">
                                <canvas id="myChart3"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Bagian Tambahan Affiliate --}}
            <div class="row justify-content-center mt-4">
                <div class="col-md-12">
                    <div class="card">
                
                        <div class="card-header">Transaction</div>

                        <div class="card-body">
                            @if (session('status'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('status') }}
                                </div>
                            @endif

                            <!-- Membungkus tabel dengan table-responsive agar responsif di perangkat kecil -->
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>No</th>
                                            <th>No KTP</th>
                                            <th>Nama</th>
                                            <th>Kode Keberangkatan</th>
                                            <th>Tanggal Keberangkatan</th>
                                            <th>Status Pembayaran</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($keberangkatans as $item)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $item->no_ktp }}</td>
                                                <td>{{ $item->nama }}</td>
                                                <td>{{ $item->kode_keberangkatan }}</td>
                                                <td>{{ date('d F Y', strtotime($item->tanggal_keberangkatan)) }}</td>
                                                <td>{{ $item->status_pembayaran }}</td>
                                                <td>
                                                <a href="#" class="btn btn-warning" onclick="approveKeberangkatan({{ $item->id }})">
                                                    Approve
                                                </a>    
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div> <!-- end of table-responsive -->

                        </div>
                    </div>
                </div>
            </div>

        </div> {{-- col-md-12 --}}
    </div> {{-- d-flex --}}
</div> {{-- container --}}

<script src="{{ asset('js/chart.js') }}"></script>
<script>
  const ctx = document.getElementById('myChart').getContext('2d');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: @json($labels),
      datasets: [{
        label: 'Jumlah Keberangkatan',
        data: @json($dataJumlah),
        borderColor: 'rgba(75, 192, 192, 1)',
        backgroundColor: 'rgba(75, 192, 192, 0.2)',
        tension: 0.3,
        borderWidth: 2,
        fill: true,
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          stepSize: 1
        }
      }
    }
  });
</script>

<script>
    const ctx2 = document.getElementById('myChart2').getContext('2d');

    new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: {!! json_encode($labels) !!},
            datasets: {!! json_encode($datasetsJenisUmroh) !!}
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    precision: 0
                }
            }
        }
    });
</script>

<script>
  const ctx3 = document.getElementById('myChart3');

  new Chart(ctx3, {
    type: 'pie',
    data: {
      labels: {!! json_encode(array_column($totalKeberangkatanAtJenisUmroh1Tahun, 'jenis_umroh')) !!},
      datasets: [{
        label: 'Total Keberangkatan',
        data: {!! json_encode(array_column($totalKeberangkatanAtJenisUmroh1Tahun, 'total')) !!},
        backgroundColor: [
          '#4dc9f6',
          '#f67019',
          '#f53794',
          '#537bc4',
          '#acc236',
          '#166a8f',
          '#00a950',
          '#58595b',
          '#8549ba'
        ],
        borderWidth: 1
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: {
          position: 'top',
        },
        title: {
          display: true,
          text: 'Total Keberangkatan per Jenis Umroh (Tahun Ini)'
        }
      }
    }
  });
</script>

<script>
    async function approveKeberangkatan(id) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const confirmResult = await swal({
            title: "Ubah Status Pembayaran",
            text: "Yakin ingin mengubah status pembayaran?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        });

        if (!confirmResult) return;

        try {
            const response = await fetch(`/keberangkatan/${id}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ id: id })
            });

            const data = await response.json();

            if (data.status) {
                swal("Berhasil!", 'Approve berhasil dilakukan', "success");
                location.reload();
            } else {
                swal("Gagal!", "Status gagal diperbarui.", "error");
            }
        } catch (error) {
            console.error('Error:', error);
            swal("Error!", "Terjadi kesalahan saat memproses permintaan.", "error");
        }
    }
</script>
@endsection
