<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;

class AfiliasiSeeder extends Seeder
{
    public function run(): void
    {
        for ($i = 1; $i <= 10; $i++) {
            // Data untuk afiliasi
            $tahun = 1990 + $i;
            $hari = str_pad($i, 2, '0', STR_PAD_LEFT);

            $nama = "User $i";
            $email = "user{$i}_" . Str::random(3) . "@example.com";
            $tanggal_lahir = Carbon::parse("$tahun-01-$hari");
            $alamat = "Jl. Contoh No. $i, Kota Contoh";
            $no_telepon = "0812345678$i";
            $no_ktp = "32760" . str_pad($i, 10, '0', STR_PAD_LEFT);
            $kode_afiliasi = "AFI" . strtoupper(Str::random(5));

            // Insert afiliasi
            $afiliasiId = DB::table('afiliasis')->insertGetId([
                'nama' => $nama,
                'email' => $email,
                'tanggal_lahir' => $tanggal_lahir,
                'alamat' => $alamat,
                'no_telepon' => $no_telepon,
                'no_ktp' => $no_ktp,
                'kode_afiliasi' => $kode_afiliasi,
                'kota' => "Kota $i",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Insert keberangkatan
            DB::table('keberangkatans')->insert([
                'no_ktp' => $no_ktp,
                'kode_keberangkatan' => 'KEB' . strtoupper(Str::random(6)),
                'id_afiliasi' => $afiliasiId,
                'tanggal_keberangkatan' => Carbon::now()->addDays($i),
                'status_pembayaran' => $i % 2 == 0 ? 'Lunas' : 'Belum Lunas',
                'tanggal_pembayaran' => $i % 2 == 0 ? Carbon::now() : null,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Insert jamaah
            DB::table('jamaahs')->insert([
                'id_afiliasi' => $afiliasiId,
                'title' => 'Tn.',
                'nama' => "Jamaah $i",
                'tempat_lahir' => "Kota $i",
                'tanggal_lahir' => $tanggal_lahir,
                'no_ktp' => '3377' . str_pad($i, 12, '0', STR_PAD_LEFT),
                'alamat' => "Alamat Jamaah $i",
                'rt' => '0' . $i,
                'rw' => '0' . $i,
                'kelurahan' => "Kelurahan $i",
                'kecamatan' => "Kecamatan $i",
                'kota' => "Kota $i",
                'provinsi' => "Provinsi $i",
                'no_passport' => 'P12345' . $i,
                'tanggal_iss' => Carbon::now()->subYears(5),
                'tanggal_expired' => Carbon::now()->addYears(5),
                'tempat_iss' => "Jakarta",
                'status_perkawinan' => $i % 2 == 0 ? 'Menikah' : 'Belum Menikah',
                'pekerjaan' => 'Pekerja',
                'nama_ayah' => "Ayah $i",
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
