<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keberangkatans', function (Blueprint $table) {
            $table->id();
            $table->string('no_ktp', 20);
            $table->string('jenis_umroh');
            $table->string('kode_keberangkatan')->unique();
            $table->string('id_afiliasi')->nullable();
            $table->date('tanggal_keberangkatan');
            $table->string('status_pembayaran')->default('Belum Lunas');
            $table->date('tanggal_pembayaran')->nullable(); 
            $table->timestamps();
            $table->softDeletes();
        });        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keberangkatans');
    }
};
