<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Keberangkatan extends Model
{
    use HasFactory, SoftDeletes;

    protected $dates = ['deleted_at'];
    
    protected $fillable = [
        'jenis_umroh',
        'no_ktp',
        'id_afiliasi',
        'kode_keberangkatan',
        'tanggal_keberangkatan',
        'status_pembayaran',
        'tanggal_pembayaran',
    ];

    public $timestamps = true;

    public function jamaah()
    {
        return $this->belongsTo(Jamaah::class, 'no_ktp', 'no_ktp');
    }

}
