<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Jamaah extends Model
{
    use HasFactory, SoftDeletes;
    protected $primaryKey = 'no_ktp';
    protected $fillable = [
        'id_afiliasi',
        'title',
        'nama',
        'tempat_lahir',
        'tanggal_lahir',
        'no_ktp',
        'alamat',
        'rt',
        'rw',
        'kelurahan',
        'kecamatan',
        'kota',
        'provinsi',
        'no_passport',
        'tanggal_iss',
        'tanggal_expired',
        'tempat_iss',
        'status_perkawinan',
        'pekerjaan',
        'nama_ayah',
    ];

    public $timestamps = true;

    public function keberangkatans()
    {
        return $this->hasMany(Keberangkatan::class, 'no_ktp', 'no_ktp');
    }

    public function getRouteKeyName()
    {
        return 'no_ktp';
    }
}
