<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Afiliasi extends Model
{
    use HasFactory, SoftDeletes;

    protected $primaryKey = 'id';  // Nama kolom ID di tabel
    protected $keyType = 'string'; // Jika ID menggunakan string atau UUID

    protected $fillable = [
        'nama',
        'email',
        'tanggal_lahir',
        'alamat',
        'no_telepon',
        'no_ktp',
        'kode_afiliasi',
        'kota'
    ];

    public $timestamps = true;

    protected $dates = ['deleted_at'];
}
