<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;

class PortalController extends Controller
{
    public function registrasi()
    {
        $jenis_umroh = DB::table('jenis_umrohs')->select('id', 'nama')->get();
        
        return view('portal', compact('jenis_umroh'));
    }

    public function download_data_keberangkatan($kode_keberangkatan)
    {
        $data = DB::table('keberangkatans')
            ->select(
                'keberangkatans.kode_keberangkatan',
                'jamaahs.title', 'jamaahs.nama', 'jamaahs.no_passport', 'jamaahs.tempat_lahir',
                'jamaahs.tanggal_lahir', 'jamaahs.tanggal_iss', 'jamaahs.tanggal_expired',
                'jamaahs.tempat_iss', 'jamaahs.no_ktp', 'jamaahs.alamat', 'jamaahs.rt',
                'jamaahs.rw', 'jamaahs.kelurahan', 'jamaahs.kecamatan', 'jamaahs.kota',
                'jamaahs.provinsi', 'jamaahs.status_perkawinan', 'jamaahs.pekerjaan', 'jamaahs.nama_ayah'
            )
            ->join('jamaahs', 'keberangkatans.no_ktp', '=', 'jamaahs.no_ktp')
            ->where('keberangkatans.kode_keberangkatan', $kode_keberangkatan)
            ->first();

        $pdf = Pdf::loadView('pdf.jamaah_pdf', compact('data'));
        return $pdf->download('laporan.pdf');
    }
}
