<?php

namespace App\Http\Controllers;

use App\Models\Keberangkatan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
{
    $totalJamaah = DB::table('keberangkatans')
    ->whereNull('deleted_at')
    ->count();

    $totalKeberangkatan = DB::table('keberangkatans')
        ->whereNull('deleted_at')
        ->distinct('kode_keberangkatan')
        ->count('kode_keberangkatan');

    $totalAfiliasi = DB::table('afiliasis')
        ->whereNull('deleted_at')
        ->count();
        
    $keberangkatans = DB::table('keberangkatans')
        ->select('keberangkatans.id', 'keberangkatans.no_ktp', 'jamaahs.nama', 'keberangkatans.kode_keberangkatan', 'keberangkatans.tanggal_keberangkatan', 'keberangkatans.status_pembayaran', 'keberangkatans.created_at')
        ->leftJoin('jamaahs', 'keberangkatans.no_ktp', '=', 'jamaahs.no_ktp')
        ->where('status_pembayaran', 'Belum Lunas')
        ->latest()
        ->take(10)
        ->get();
    
    $topAfiliasis = DB::table('afiliasis')
        ->join('jamaahs', 'jamaahs.id_afiliasi', '=', 'afiliasis.kode_afiliasi')
        ->select('afiliasis.nama', DB::raw('COUNT(jamaahs.id) as jumlah'))
        ->groupBy('afiliasis.nama')
        ->orderByDesc('jumlah')
        ->limit(10)
        ->get();

    $bulan = DB::select("
        WITH RECURSIVE bulan_cte AS (
            SELECT 1 AS bulan
            UNION ALL
            SELECT bulan + 1 FROM bulan_cte WHERE bulan < 12
        )
        SELECT 
            bulan_cte.bulan,
            COALESCE(COUNT(k.id), 0) AS jumlah
        FROM bulan_cte
        LEFT JOIN keberangkatans k 
            ON MONTH(k.tanggal_keberangkatan) = bulan_cte.bulan
            AND YEAR(k.tanggal_keberangkatan) = YEAR(CURDATE())
        GROUP BY bulan_cte.bulan
        ORDER BY bulan_cte.bulan
    ");

    $labels = [
        'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];

    $dataJumlah = array_fill(0, 12, 0); // isi awal 0 untuk semua bulan

    foreach ($bulan as $item) {
        $index = (int)$item->bulan - 1;
        $dataJumlah[$index] = (int)$item->jumlah;
    }

    $totalKeberangkatanAtJenisUmroh = DB::select("
        WITH RECURSIVE bulan_cte AS (
            SELECT 1 AS bulan
            UNION ALL
            SELECT bulan + 1 FROM bulan_cte WHERE bulan < 12
        )
        SELECT 
            bu.bulan,
            j.nama AS jenis_umroh,
            COUNT(k.id) AS jumlah
        FROM bulan_cte bu
        CROSS JOIN jenis_umrohs j
        LEFT JOIN keberangkatans k 
            ON MONTH(k.tanggal_keberangkatan) = bu.bulan
            AND YEAR(k.tanggal_keberangkatan) = YEAR(CURDATE())
            AND k.jenis_umroh = j.id
            AND k.deleted_at IS NULL
        WHERE j.deleted_at IS NULL
        GROUP BY bu.bulan, j.nama
        ORDER BY bu.bulan, j.nama
    ");


    $jenisUmrohList = DB::table('jenis_umrohs')->whereNull('deleted_at')->pluck('nama');

    $datasetsJenisUmroh = [];

    foreach ($jenisUmrohList as $jenis) {
        $dataPerJenis = array_fill(0, 12, 0); // 12 bulan default 0

        foreach ($totalKeberangkatanAtJenisUmroh as $row) {
            if ($row->jenis_umroh === $jenis) {
                $index = (int)$row->bulan - 1;
                $dataPerJenis[$index] = (int)$row->jumlah;
            }
        }

        $datasetsJenisUmroh[] = [
            'label' => $jenis,
            'data' => $dataPerJenis,
            'borderWidth' => 1
        ];
    }
    
    $totalKeberangkatanAtJenisUmroh1Tahun = DB::select("
        SELECT 
            j.nama AS jenis_umroh,
            COUNT(k.id) AS total
        FROM jenis_umrohs j
        LEFT JOIN keberangkatans k 
            ON k.jenis_umroh = j.id
            AND YEAR(k.tanggal_keberangkatan) = YEAR(CURDATE())
            AND k.deleted_at IS NULL
        WHERE j.deleted_at IS NULL
        GROUP BY j.nama
        ORDER BY j.nama
    ");


    return view('admin.dashboard', compact(
        'totalJamaah',
        'totalKeberangkatan',
        'totalAfiliasi',
        'keberangkatans', 
        'topAfiliasis', 
        'labels', 
        'dataJumlah',
        'datasetsJenisUmroh',
        'totalKeberangkatanAtJenisUmroh1Tahun'
    ));
}

}
