<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class KeberangkatanExport implements FromCollection
{
    protected $tanggal;
    protected $status;

    public function __construct($tanggal, $status)
    {
        $this->tanggal = $tanggal;
        $this->status = $status;
    }

    public function collection()
    {
        $query = DB::table('keberangkatans')
            ->select(
                'jamaahs.title', 'keberangkatans.jenis_umroh', 'jamaahs.nama', 'jamaahs.no_passport', 'jamaahs.tempat_lahir',
                'jamaahs.tanggal_lahir', 'jamaahs.tanggal_iss', 'jamaahs.tanggal_expired',
                'jamaahs.tempat_iss', 'jamaahs.no_ktp', 'jamaahs.alamat', 'jamaahs.rt',
                'jamaahs.rw', 'jamaahs.kelurahan', 'jamaahs.kecamatan', 'jamaahs.kota',
                'jamaahs.provinsi', 'jamaahs.status_perkawinan', 'jamaahs.pekerjaan', 'jamaahs.nama_ayah'
            )
            ->leftjoin('jamaahs', 'jamaahs.no_ktp', '=', 'keberangkatans.no_ktp');

        if ($this->tanggal) {
            $query->where('keberangkatans.tanggal_keberangkatan', $this->tanggal);
        }

        if ($this->status) {
            $query->where('keberangkatans.status_pembayaran', $this->status);
        }

        $data = $query->get();

        // Tambahkan kolom NO dan ubah semua data jadi uppercase
       return $data->map(function ($row, $index) {
            $formatted = collect($row)->map(function ($value, $key) {
                $value = strtoupper((string) $value);

                // Kolom-kolom yang harus dipaksa jadi string agar 0 tidak hilang
                $forceStringFields = ['no_ktp', 'rt', 'rw', 'no_passport'];

                if (in_array($key, $forceStringFields)) {
                    return "'" . $value; // ← tambahkan tanda petik satu di awal
                }

                return $value;
            });

            // Tambahkan kolom NO di awal
            return collect(['NO' => $index + 1])->merge($formatted);
        });

    }

    public function headings(): array
    {
        return [
            'NO', 'JENIS UMROH', 'TITLE', 'NAMA', 'NO PASSPORT', 'TEMPAT LAHIR', 'TANGGAL LAHIR', 'TANGGAL ISS',
            'TANGGAL EXPIRED', 'TEMPAT ISS', 'NO KTP', 'ALAMAT', 'RT', 'RW',
            'KELURAHAN', 'KECAMATAN', 'KOTA', 'PROVINSI', 'STATUS PERKAWINAN',
            'PEKERJAAN', 'NAMA AYAH'
        ];
    }
}
