<?php

namespace App\Exports;

use App\Models\Jamaah;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class JamaahExport implements FromCollection, WithHeadings, WithMapping
{
    protected $start_tanggal;
    protected $end_tanggal;
    protected $kota;

    public function __construct($start_tanggal, $end_tanggal, $kota)
    {
        $this->start_tanggal = $start_tanggal;
        $this->end_tanggal = $end_tanggal;
        $this->kota = $kota;
    }

    public function headings(): array
    {
        return [
            'NO', 'TITLE', 'NAMA', 'NO PASSPORT', 'TEMPAT LAHIR', 'TANGGAL LAHIR', 'TANGGAL ISS',
            'TANGGAL EXPIRED', 'TEMPAT ISS', 'NO KTP', 'ALAMAT', 'RT', 'RW',
            'KELURAHAN', 'KECAMATAN', 'KOTA', 'PROVINSI', 'STATUS PERKAWINAN',
            'PEKERJAAN', 'NAMA AYAH'
        ];
    }

    public function collection()
    {
        $query = Jamaah::query();

        // Filter berdasarkan start tanggal
        if ($this->start_tanggal) {
            $query->where('created_at', '>=', $this->start_tanggal);
        }

        // Filter berdasarkan end tanggal
        if ($this->end_tanggal) {
            $query->where('created_at', '<=', $this->end_tanggal);
        }

        // Filter berdasarkan kota
        if ($this->kota) {
            $query->where('kota', 'like', '%' . $this->kota . '%');
        }

        // Ambil data jamaah
        $jamaahs = $query->get();

        return $jamaahs->map(function ($jamaah, $index) {
            return [
                $index + 1,
                strtoupper($jamaah->title),
                strtoupper($jamaah->nama),
                strtoupper($jamaah->no_passport),
                strtoupper($jamaah->tempat_lahir),
                $jamaah->tanggal_lahir,
                $jamaah->tanggal_iss,
                $jamaah->tanggal_expired,
                strtoupper($jamaah->tempat_iss),
                "'" . $jamaah->no_ktp,
                strtoupper($jamaah->alamat),
                "'" . $jamaah->rt,
                "'" . $jamaah->rw,
                strtoupper($jamaah->kelurahan),
                strtoupper($jamaah->kecamatan),
                strtoupper($jamaah->kota),
                strtoupper($jamaah->provinsi),
                strtoupper($jamaah->status_perkawinan),
                strtoupper($jamaah->pekerjaan),
                strtoupper($jamaah->nama_ayah),
            ];
        });
        
    }
}
