<?php

namespace App\Exports;

use App\Models\Afiliasi;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class AfiliasiExport implements FromCollection, WithHeadings, WithMapping
{
    protected $start_tanggal;
    protected $end_tanggal;
    protected $kota;

    public function __construct($start_tanggal, $end_tanggal, $kota)
    {
        $this->start_tanggal = $start_tanggal;
        $this->end_tanggal = $end_tanggal;
        $this->kota = $kota;
    }

    public function headings(): array
    {
        return [
            'NO', 'NAMA', 'EMAIL', 'TANGGAL LAHIR', 'ALAMAT', 'NO TELEPON', 'NO KTP', 'KODE AFILIASI', 'TANGGAL DIBUAT'
        ];
    }

    public function collection()
    {
        $query = Afiliasi::query();

        // Filter berdasarkan start_tanggal dan end_tanggal
        if ($this->start_tanggal) {
            $query->where('created_at', '>=', $this->start_tanggal);
        }
        if ($this->end_tanggal) {
            $query->where('created_at', '<=', $this->end_tanggal);
        }

        // Filter berdasarkan kota
        if ($this->kota) {
            $query->where('kota', 'like', '%' . $this->kota . '%');
        }

        // Ambil data Afiliasi
        return $query->get();

        return $afiliasi->map(function ($afiliasi, $index) {
            return [
                strtoupper((string) ($index + 1)),
                strtoupper((string) $afiliasi->nama),
                strtoupper((string) $afiliasi->email),
                strtoupper((string) $afiliasi->tanggal_lahir),
                strtoupper((string) $afiliasi->alamat),
                strtoupper((string) $afiliasi->no_telepon),
                "'" . $afiliasi->no_ktp,
                strtoupper((string) $afiliasi->kode_afiliasi),
            ];
        });
    }
}
